/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropOptical;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropOpticalVer14
implements OFPortDescPropOptical {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropOpticalVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 44;
    private static final long DEFAULT_SUPPORTED = 0L;
    private static final long DEFAULT_TX_MIN_FREQ_LMDA = 0L;
    private static final long DEFAULT_TX_MAX_FREQ_LMDA = 0L;
    private static final long DEFAULT_TX_GRID_FREQ_LMDA = 0L;
    private static final long DEFAULT_RX_MIN_FREQ_LMDA = 0L;
    private static final long DEFAULT_RX_MAX_FREQ_LMDA = 0L;
    private static final long DEFAULT_RX_GRID_FREQ_LMDA = 0L;
    private static final long DEFAULT_TX_PWR_MIN = 0L;
    private static final long DEFAULT_TX_PWR_MAX = 0L;
    private final long supported;
    private final long txMinFreqLmda;
    private final long txMaxFreqLmda;
    private final long txGridFreqLmda;
    private final long rxMinFreqLmda;
    private final long rxMaxFreqLmda;
    private final long rxGridFreqLmda;
    private final long txPwrMin;
    private final long txPwrMax;
    static final OFPortDescPropOpticalVer14 DEFAULT = new OFPortDescPropOpticalVer14(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFPortDescPropOpticalVer14Funnel FUNNEL = new OFPortDescPropOpticalVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropOpticalVer14(long supported, long txMinFreqLmda, long txMaxFreqLmda, long txGridFreqLmda, long rxMinFreqLmda, long rxMaxFreqLmda, long rxGridFreqLmda, long txPwrMin, long txPwrMax) {
        this.supported = supported;
        this.txMinFreqLmda = txMinFreqLmda;
        this.txMaxFreqLmda = txMaxFreqLmda;
        this.txGridFreqLmda = txGridFreqLmda;
        this.rxMinFreqLmda = rxMinFreqLmda;
        this.rxMaxFreqLmda = rxMaxFreqLmda;
        this.rxGridFreqLmda = rxGridFreqLmda;
        this.txPwrMin = txPwrMin;
        this.txPwrMax = txPwrMax;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public long getSupported() {
        return this.supported;
    }

    @Override
    public long getTxMinFreqLmda() {
        return this.txMinFreqLmda;
    }

    @Override
    public long getTxMaxFreqLmda() {
        return this.txMaxFreqLmda;
    }

    @Override
    public long getTxGridFreqLmda() {
        return this.txGridFreqLmda;
    }

    @Override
    public long getRxMinFreqLmda() {
        return this.rxMinFreqLmda;
    }

    @Override
    public long getRxMaxFreqLmda() {
        return this.rxMaxFreqLmda;
    }

    @Override
    public long getRxGridFreqLmda() {
        return this.rxGridFreqLmda;
    }

    @Override
    public long getTxPwrMin() {
        return this.txPwrMin;
    }

    @Override
    public long getTxPwrMax() {
        return this.txPwrMax;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortDescPropOptical.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropOpticalVer14(");
        b.append("supported=").append(this.supported);
        b.append(", ");
        b.append("txMinFreqLmda=").append(this.txMinFreqLmda);
        b.append(", ");
        b.append("txMaxFreqLmda=").append(this.txMaxFreqLmda);
        b.append(", ");
        b.append("txGridFreqLmda=").append(this.txGridFreqLmda);
        b.append(", ");
        b.append("rxMinFreqLmda=").append(this.rxMinFreqLmda);
        b.append(", ");
        b.append("rxMaxFreqLmda=").append(this.rxMaxFreqLmda);
        b.append(", ");
        b.append("rxGridFreqLmda=").append(this.rxGridFreqLmda);
        b.append(", ");
        b.append("txPwrMin=").append(this.txPwrMin);
        b.append(", ");
        b.append("txPwrMax=").append(this.txPwrMax);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropOpticalVer14 other = (OFPortDescPropOpticalVer14)obj;
        if (this.supported != other.supported) {
            return false;
        }
        if (this.txMinFreqLmda != other.txMinFreqLmda) {
            return false;
        }
        if (this.txMaxFreqLmda != other.txMaxFreqLmda) {
            return false;
        }
        if (this.txGridFreqLmda != other.txGridFreqLmda) {
            return false;
        }
        if (this.rxMinFreqLmda != other.rxMinFreqLmda) {
            return false;
        }
        if (this.rxMaxFreqLmda != other.rxMaxFreqLmda) {
            return false;
        }
        if (this.rxGridFreqLmda != other.rxGridFreqLmda) {
            return false;
        }
        if (this.txPwrMin != other.txPwrMin) {
            return false;
        }
        return this.txPwrMax == other.txPwrMax;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.supported ^ this.supported >>> 32);
        result = 31 * (int)(this.txMinFreqLmda ^ this.txMinFreqLmda >>> 32);
        result = 31 * (int)(this.txMaxFreqLmda ^ this.txMaxFreqLmda >>> 32);
        result = 31 * (int)(this.txGridFreqLmda ^ this.txGridFreqLmda >>> 32);
        result = 31 * (int)(this.rxMinFreqLmda ^ this.rxMinFreqLmda >>> 32);
        result = 31 * (int)(this.rxMaxFreqLmda ^ this.rxMaxFreqLmda >>> 32);
        result = 31 * (int)(this.rxGridFreqLmda ^ this.rxGridFreqLmda >>> 32);
        result = 31 * (int)(this.txPwrMin ^ this.txPwrMin >>> 32);
        result = 31 * (int)(this.txPwrMax ^ this.txPwrMax >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropOpticalVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortDescPropOpticalVer14 message) {
            bb.writeShort(1);
            bb.writeShort(44);
            bb.writeZero(4);
            bb.writeInt(U32.t(message.supported));
            bb.writeInt(U32.t(message.txMinFreqLmda));
            bb.writeInt(U32.t(message.txMaxFreqLmda));
            bb.writeInt(U32.t(message.txGridFreqLmda));
            bb.writeInt(U32.t(message.rxMinFreqLmda));
            bb.writeInt(U32.t(message.rxMaxFreqLmda));
            bb.writeInt(U32.t(message.rxGridFreqLmda));
            bb.writeInt(U32.t(message.txPwrMin));
            bb.writeInt(U32.t(message.txPwrMax));
        }
    }

    static class OFPortDescPropOpticalVer14Funnel
    implements Funnel<OFPortDescPropOpticalVer14> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropOpticalVer14Funnel() {
        }

        public void funnel(OFPortDescPropOpticalVer14 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)44);
            sink.putLong(message.supported);
            sink.putLong(message.txMinFreqLmda);
            sink.putLong(message.txMaxFreqLmda);
            sink.putLong(message.txGridFreqLmda);
            sink.putLong(message.rxMinFreqLmda);
            sink.putLong(message.rxMaxFreqLmda);
            sink.putLong(message.rxGridFreqLmda);
            sink.putLong(message.txPwrMin);
            sink.putLong(message.txPwrMax);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropOptical> {
        Reader() {
        }

        @Override
        public OFPortDescPropOptical readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 44) {
                throw new OFParseError("Wrong length: Expected=44(44), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            long supported = U32.f(bb.readInt());
            long txMinFreqLmda = U32.f(bb.readInt());
            long txMaxFreqLmda = U32.f(bb.readInt());
            long txGridFreqLmda = U32.f(bb.readInt());
            long rxMinFreqLmda = U32.f(bb.readInt());
            long rxMaxFreqLmda = U32.f(bb.readInt());
            long rxGridFreqLmda = U32.f(bb.readInt());
            long txPwrMin = U32.f(bb.readInt());
            long txPwrMax = U32.f(bb.readInt());
            OFPortDescPropOpticalVer14 portDescPropOpticalVer14 = new OFPortDescPropOpticalVer14(supported, txMinFreqLmda, txMaxFreqLmda, txGridFreqLmda, rxMinFreqLmda, rxMaxFreqLmda, rxGridFreqLmda, txPwrMin, txPwrMax);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropOpticalVer14);
            }
            return portDescPropOpticalVer14;
        }
    }

    static class Builder
    implements OFPortDescPropOptical.Builder {
        private boolean supportedSet;
        private long supported;
        private boolean txMinFreqLmdaSet;
        private long txMinFreqLmda;
        private boolean txMaxFreqLmdaSet;
        private long txMaxFreqLmda;
        private boolean txGridFreqLmdaSet;
        private long txGridFreqLmda;
        private boolean rxMinFreqLmdaSet;
        private long rxMinFreqLmda;
        private boolean rxMaxFreqLmdaSet;
        private long rxMaxFreqLmda;
        private boolean rxGridFreqLmdaSet;
        private long rxGridFreqLmda;
        private boolean txPwrMinSet;
        private long txPwrMin;
        private boolean txPwrMaxSet;
        private long txPwrMax;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getSupported() {
            return this.supported;
        }

        @Override
        public OFPortDescPropOptical.Builder setSupported(long supported) {
            this.supported = supported;
            this.supportedSet = true;
            return this;
        }

        @Override
        public long getTxMinFreqLmda() {
            return this.txMinFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setTxMinFreqLmda(long txMinFreqLmda) {
            this.txMinFreqLmda = txMinFreqLmda;
            this.txMinFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getTxMaxFreqLmda() {
            return this.txMaxFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setTxMaxFreqLmda(long txMaxFreqLmda) {
            this.txMaxFreqLmda = txMaxFreqLmda;
            this.txMaxFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getTxGridFreqLmda() {
            return this.txGridFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setTxGridFreqLmda(long txGridFreqLmda) {
            this.txGridFreqLmda = txGridFreqLmda;
            this.txGridFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getRxMinFreqLmda() {
            return this.rxMinFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setRxMinFreqLmda(long rxMinFreqLmda) {
            this.rxMinFreqLmda = rxMinFreqLmda;
            this.rxMinFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getRxMaxFreqLmda() {
            return this.rxMaxFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setRxMaxFreqLmda(long rxMaxFreqLmda) {
            this.rxMaxFreqLmda = rxMaxFreqLmda;
            this.rxMaxFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getRxGridFreqLmda() {
            return this.rxGridFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setRxGridFreqLmda(long rxGridFreqLmda) {
            this.rxGridFreqLmda = rxGridFreqLmda;
            this.rxGridFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getTxPwrMin() {
            return this.txPwrMin;
        }

        @Override
        public OFPortDescPropOptical.Builder setTxPwrMin(long txPwrMin) {
            this.txPwrMin = txPwrMin;
            this.txPwrMinSet = true;
            return this;
        }

        @Override
        public long getTxPwrMax() {
            return this.txPwrMax;
        }

        @Override
        public OFPortDescPropOptical.Builder setTxPwrMax(long txPwrMax) {
            this.txPwrMax = txPwrMax;
            this.txPwrMaxSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropOptical build() {
            long supported = this.supportedSet ? this.supported : 0L;
            long txMinFreqLmda = this.txMinFreqLmdaSet ? this.txMinFreqLmda : 0L;
            long txMaxFreqLmda = this.txMaxFreqLmdaSet ? this.txMaxFreqLmda : 0L;
            long txGridFreqLmda = this.txGridFreqLmdaSet ? this.txGridFreqLmda : 0L;
            long rxMinFreqLmda = this.rxMinFreqLmdaSet ? this.rxMinFreqLmda : 0L;
            long rxMaxFreqLmda = this.rxMaxFreqLmdaSet ? this.rxMaxFreqLmda : 0L;
            long rxGridFreqLmda = this.rxGridFreqLmdaSet ? this.rxGridFreqLmda : 0L;
            long txPwrMin = this.txPwrMinSet ? this.txPwrMin : 0L;
            long txPwrMax = this.txPwrMaxSet ? this.txPwrMax : 0L;
            return new OFPortDescPropOpticalVer14(supported, txMinFreqLmda, txMaxFreqLmda, txGridFreqLmda, rxMinFreqLmda, rxMaxFreqLmda, rxGridFreqLmda, txPwrMin, txPwrMax);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropOptical.Builder {
        final OFPortDescPropOpticalVer14 parentMessage;
        private boolean supportedSet;
        private long supported;
        private boolean txMinFreqLmdaSet;
        private long txMinFreqLmda;
        private boolean txMaxFreqLmdaSet;
        private long txMaxFreqLmda;
        private boolean txGridFreqLmdaSet;
        private long txGridFreqLmda;
        private boolean rxMinFreqLmdaSet;
        private long rxMinFreqLmda;
        private boolean rxMaxFreqLmdaSet;
        private long rxMaxFreqLmda;
        private boolean rxGridFreqLmdaSet;
        private long rxGridFreqLmda;
        private boolean txPwrMinSet;
        private long txPwrMin;
        private boolean txPwrMaxSet;
        private long txPwrMax;

        BuilderWithParent(OFPortDescPropOpticalVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getSupported() {
            return this.supported;
        }

        @Override
        public OFPortDescPropOptical.Builder setSupported(long supported) {
            this.supported = supported;
            this.supportedSet = true;
            return this;
        }

        @Override
        public long getTxMinFreqLmda() {
            return this.txMinFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setTxMinFreqLmda(long txMinFreqLmda) {
            this.txMinFreqLmda = txMinFreqLmda;
            this.txMinFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getTxMaxFreqLmda() {
            return this.txMaxFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setTxMaxFreqLmda(long txMaxFreqLmda) {
            this.txMaxFreqLmda = txMaxFreqLmda;
            this.txMaxFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getTxGridFreqLmda() {
            return this.txGridFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setTxGridFreqLmda(long txGridFreqLmda) {
            this.txGridFreqLmda = txGridFreqLmda;
            this.txGridFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getRxMinFreqLmda() {
            return this.rxMinFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setRxMinFreqLmda(long rxMinFreqLmda) {
            this.rxMinFreqLmda = rxMinFreqLmda;
            this.rxMinFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getRxMaxFreqLmda() {
            return this.rxMaxFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setRxMaxFreqLmda(long rxMaxFreqLmda) {
            this.rxMaxFreqLmda = rxMaxFreqLmda;
            this.rxMaxFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getRxGridFreqLmda() {
            return this.rxGridFreqLmda;
        }

        @Override
        public OFPortDescPropOptical.Builder setRxGridFreqLmda(long rxGridFreqLmda) {
            this.rxGridFreqLmda = rxGridFreqLmda;
            this.rxGridFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getTxPwrMin() {
            return this.txPwrMin;
        }

        @Override
        public OFPortDescPropOptical.Builder setTxPwrMin(long txPwrMin) {
            this.txPwrMin = txPwrMin;
            this.txPwrMinSet = true;
            return this;
        }

        @Override
        public long getTxPwrMax() {
            return this.txPwrMax;
        }

        @Override
        public OFPortDescPropOptical.Builder setTxPwrMax(long txPwrMax) {
            this.txPwrMax = txPwrMax;
            this.txPwrMaxSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropOptical build() {
            long supported = this.supportedSet ? this.supported : this.parentMessage.supported;
            long txMinFreqLmda = this.txMinFreqLmdaSet ? this.txMinFreqLmda : this.parentMessage.txMinFreqLmda;
            long txMaxFreqLmda = this.txMaxFreqLmdaSet ? this.txMaxFreqLmda : this.parentMessage.txMaxFreqLmda;
            long txGridFreqLmda = this.txGridFreqLmdaSet ? this.txGridFreqLmda : this.parentMessage.txGridFreqLmda;
            long rxMinFreqLmda = this.rxMinFreqLmdaSet ? this.rxMinFreqLmda : this.parentMessage.rxMinFreqLmda;
            long rxMaxFreqLmda = this.rxMaxFreqLmdaSet ? this.rxMaxFreqLmda : this.parentMessage.rxMaxFreqLmda;
            long rxGridFreqLmda = this.rxGridFreqLmdaSet ? this.rxGridFreqLmda : this.parentMessage.rxGridFreqLmda;
            long txPwrMin = this.txPwrMinSet ? this.txPwrMin : this.parentMessage.txPwrMin;
            long txPwrMax = this.txPwrMaxSet ? this.txPwrMax : this.parentMessage.txPwrMax;
            return new OFPortDescPropOpticalVer14(supported, txMinFreqLmda, txMaxFreqLmda, txGridFreqLmda, rxMinFreqLmda, rxMaxFreqLmda, rxGridFreqLmda, txPwrMin, txPwrMax);
        }
    }
}

