/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortStatsPropEthernet;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatsPropEthernetVer14
implements OFPortStatsPropEthernet {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatsPropEthernetVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 40;
    private static final U64 DEFAULT_RX_FRAME_ERR = U64.ZERO;
    private static final U64 DEFAULT_RX_OVER_ERR = U64.ZERO;
    private static final U64 DEFAULT_RX_CRC_ERR = U64.ZERO;
    private static final U64 DEFAULT_COLLISIONS = U64.ZERO;
    private final U64 rxFrameErr;
    private final U64 rxOverErr;
    private final U64 rxCrcErr;
    private final U64 collisions;
    static final OFPortStatsPropEthernetVer14 DEFAULT = new OFPortStatsPropEthernetVer14(DEFAULT_RX_FRAME_ERR, DEFAULT_RX_OVER_ERR, DEFAULT_RX_CRC_ERR, DEFAULT_COLLISIONS);
    static final Reader READER = new Reader();
    static final OFPortStatsPropEthernetVer14Funnel FUNNEL = new OFPortStatsPropEthernetVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatsPropEthernetVer14(U64 rxFrameErr, U64 rxOverErr, U64 rxCrcErr, U64 collisions) {
        if (rxFrameErr == null) {
            throw new NullPointerException("OFPortStatsPropEthernetVer14: property rxFrameErr cannot be null");
        }
        if (rxOverErr == null) {
            throw new NullPointerException("OFPortStatsPropEthernetVer14: property rxOverErr cannot be null");
        }
        if (rxCrcErr == null) {
            throw new NullPointerException("OFPortStatsPropEthernetVer14: property rxCrcErr cannot be null");
        }
        if (collisions == null) {
            throw new NullPointerException("OFPortStatsPropEthernetVer14: property collisions cannot be null");
        }
        this.rxFrameErr = rxFrameErr;
        this.rxOverErr = rxOverErr;
        this.rxCrcErr = rxCrcErr;
        this.collisions = collisions;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public U64 getRxFrameErr() {
        return this.rxFrameErr;
    }

    @Override
    public U64 getRxOverErr() {
        return this.rxOverErr;
    }

    @Override
    public U64 getRxCrcErr() {
        return this.rxCrcErr;
    }

    @Override
    public U64 getCollisions() {
        return this.collisions;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortStatsPropEthernet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatsPropEthernetVer14(");
        b.append("rxFrameErr=").append(this.rxFrameErr);
        b.append(", ");
        b.append("rxOverErr=").append(this.rxOverErr);
        b.append(", ");
        b.append("rxCrcErr=").append(this.rxCrcErr);
        b.append(", ");
        b.append("collisions=").append(this.collisions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatsPropEthernetVer14 other = (OFPortStatsPropEthernetVer14)obj;
        if (this.rxFrameErr == null ? other.rxFrameErr != null : !this.rxFrameErr.equals(other.rxFrameErr)) {
            return false;
        }
        if (this.rxOverErr == null ? other.rxOverErr != null : !this.rxOverErr.equals(other.rxOverErr)) {
            return false;
        }
        if (this.rxCrcErr == null ? other.rxCrcErr != null : !this.rxCrcErr.equals(other.rxCrcErr)) {
            return false;
        }
        return !(this.collisions == null ? other.collisions != null : !this.collisions.equals(other.collisions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rxFrameErr == null ? 0 : this.rxFrameErr.hashCode());
        result = 31 * result + (this.rxOverErr == null ? 0 : this.rxOverErr.hashCode());
        result = 31 * result + (this.rxCrcErr == null ? 0 : this.rxCrcErr.hashCode());
        result = 31 * result + (this.collisions == null ? 0 : this.collisions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatsPropEthernetVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortStatsPropEthernetVer14 message) {
            bb.writeShort(0);
            bb.writeShort(40);
            bb.writeZero(4);
            bb.writeLong(message.rxFrameErr.getValue());
            bb.writeLong(message.rxOverErr.getValue());
            bb.writeLong(message.rxCrcErr.getValue());
            bb.writeLong(message.collisions.getValue());
        }
    }

    static class OFPortStatsPropEthernetVer14Funnel
    implements Funnel<OFPortStatsPropEthernetVer14> {
        private static final long serialVersionUID = 1L;

        OFPortStatsPropEthernetVer14Funnel() {
        }

        public void funnel(OFPortStatsPropEthernetVer14 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)40);
            message.rxFrameErr.putTo(sink);
            message.rxOverErr.putTo(sink);
            message.rxCrcErr.putTo(sink);
            message.collisions.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatsPropEthernet> {
        Reader() {
        }

        @Override
        public OFPortStatsPropEthernet readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 40) {
                throw new OFParseError("Wrong length: Expected=40(40), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            U64 rxFrameErr = U64.ofRaw(bb.readLong());
            U64 rxOverErr = U64.ofRaw(bb.readLong());
            U64 rxCrcErr = U64.ofRaw(bb.readLong());
            U64 collisions = U64.ofRaw(bb.readLong());
            OFPortStatsPropEthernetVer14 portStatsPropEthernetVer14 = new OFPortStatsPropEthernetVer14(rxFrameErr, rxOverErr, rxCrcErr, collisions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatsPropEthernetVer14);
            }
            return portStatsPropEthernetVer14;
        }
    }

    static class Builder
    implements OFPortStatsPropEthernet.Builder {
        private boolean rxFrameErrSet;
        private U64 rxFrameErr;
        private boolean rxOverErrSet;
        private U64 rxOverErr;
        private boolean rxCrcErrSet;
        private U64 rxCrcErr;
        private boolean collisionsSet;
        private U64 collisions;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public U64 getRxFrameErr() {
            return this.rxFrameErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxFrameErr(U64 rxFrameErr) {
            this.rxFrameErr = rxFrameErr;
            this.rxFrameErrSet = true;
            return this;
        }

        @Override
        public U64 getRxOverErr() {
            return this.rxOverErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxOverErr(U64 rxOverErr) {
            this.rxOverErr = rxOverErr;
            this.rxOverErrSet = true;
            return this;
        }

        @Override
        public U64 getRxCrcErr() {
            return this.rxCrcErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxCrcErr(U64 rxCrcErr) {
            this.rxCrcErr = rxCrcErr;
            this.rxCrcErrSet = true;
            return this;
        }

        @Override
        public U64 getCollisions() {
            return this.collisions;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setCollisions(U64 collisions) {
            this.collisions = collisions;
            this.collisionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortStatsPropEthernet build() {
            U64 collisions;
            U64 rxCrcErr;
            U64 rxOverErr;
            U64 rxFrameErr;
            U64 u64 = rxFrameErr = this.rxFrameErrSet ? this.rxFrameErr : DEFAULT_RX_FRAME_ERR;
            if (rxFrameErr == null) {
                throw new NullPointerException("Property rxFrameErr must not be null");
            }
            U64 u642 = rxOverErr = this.rxOverErrSet ? this.rxOverErr : DEFAULT_RX_OVER_ERR;
            if (rxOverErr == null) {
                throw new NullPointerException("Property rxOverErr must not be null");
            }
            U64 u643 = rxCrcErr = this.rxCrcErrSet ? this.rxCrcErr : DEFAULT_RX_CRC_ERR;
            if (rxCrcErr == null) {
                throw new NullPointerException("Property rxCrcErr must not be null");
            }
            U64 u644 = collisions = this.collisionsSet ? this.collisions : DEFAULT_COLLISIONS;
            if (collisions == null) {
                throw new NullPointerException("Property collisions must not be null");
            }
            return new OFPortStatsPropEthernetVer14(rxFrameErr, rxOverErr, rxCrcErr, collisions);
        }
    }

    static class BuilderWithParent
    implements OFPortStatsPropEthernet.Builder {
        final OFPortStatsPropEthernetVer14 parentMessage;
        private boolean rxFrameErrSet;
        private U64 rxFrameErr;
        private boolean rxOverErrSet;
        private U64 rxOverErr;
        private boolean rxCrcErrSet;
        private U64 rxCrcErr;
        private boolean collisionsSet;
        private U64 collisions;

        BuilderWithParent(OFPortStatsPropEthernetVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public U64 getRxFrameErr() {
            return this.rxFrameErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxFrameErr(U64 rxFrameErr) {
            this.rxFrameErr = rxFrameErr;
            this.rxFrameErrSet = true;
            return this;
        }

        @Override
        public U64 getRxOverErr() {
            return this.rxOverErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxOverErr(U64 rxOverErr) {
            this.rxOverErr = rxOverErr;
            this.rxOverErrSet = true;
            return this;
        }

        @Override
        public U64 getRxCrcErr() {
            return this.rxCrcErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxCrcErr(U64 rxCrcErr) {
            this.rxCrcErr = rxCrcErr;
            this.rxCrcErrSet = true;
            return this;
        }

        @Override
        public U64 getCollisions() {
            return this.collisions;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setCollisions(U64 collisions) {
            this.collisions = collisions;
            this.collisionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortStatsPropEthernet build() {
            U64 collisions;
            U64 rxCrcErr;
            U64 rxOverErr;
            U64 rxFrameErr;
            U64 u64 = rxFrameErr = this.rxFrameErrSet ? this.rxFrameErr : this.parentMessage.rxFrameErr;
            if (rxFrameErr == null) {
                throw new NullPointerException("Property rxFrameErr must not be null");
            }
            U64 u642 = rxOverErr = this.rxOverErrSet ? this.rxOverErr : this.parentMessage.rxOverErr;
            if (rxOverErr == null) {
                throw new NullPointerException("Property rxOverErr must not be null");
            }
            U64 u643 = rxCrcErr = this.rxCrcErrSet ? this.rxCrcErr : this.parentMessage.rxCrcErr;
            if (rxCrcErr == null) {
                throw new NullPointerException("Property rxCrcErr must not be null");
            }
            U64 u644 = collisions = this.collisionsSet ? this.collisions : this.parentMessage.collisions;
            if (collisions == null) {
                throw new NullPointerException("Property collisions must not be null");
            }
            return new OFPortStatsPropEthernetVer14(rxFrameErr, rxOverErr, rxCrcErr, collisions);
        }
    }
}

