/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.ver14.OFAggregateStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFDescStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFExperimenterStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupDescStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupFeaturesStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterConfigStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterFeaturesStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPortDescStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPortStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFQueueDescStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFQueueStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableDescStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableFeaturesStatsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableStatsReplyVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsReplyVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFStatsReplyVer14() {
    }

    static class Reader
    implements OFMessageReader<OFStatsReply> {
        Reader() {
        }

        @Override
        public OFStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsReplyVer14.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsReplyVer14.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsReplyVer14.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsReplyVer14.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsReplyVer14.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsReplyVer14.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsReplyVer14.READER.readFrom(bb);
                }
                case 7: {
                    return OFGroupDescStatsReplyVer14.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupStatsReplyVer14.READER.readFrom(bb);
                }
                case 8: {
                    return OFGroupFeaturesStatsReplyVer14.READER.readFrom(bb);
                }
                case 10: {
                    return OFMeterConfigStatsReplyVer14.READER.readFrom(bb);
                }
                case 11: {
                    return OFMeterFeaturesStatsReplyVer14.READER.readFrom(bb);
                }
                case 9: {
                    return OFMeterStatsReplyVer14.READER.readFrom(bb);
                }
                case 13: {
                    return OFPortDescStatsReplyVer14.READER.readFrom(bb);
                }
                case 12: {
                    return OFTableFeaturesStatsReplyVer14.READER.readFrom(bb);
                }
                case 15: {
                    return OFQueueDescStatsReplyVer14.READER.readFrom(bb);
                }
                case 14: {
                    return OFTableDescStatsReplyVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsReplyVer14: " + statsType);
        }
    }
}

