/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropNextTablesMiss;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropNextTablesMissVer14
implements OFTableFeaturePropNextTablesMiss {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropNextTablesMissVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final List<U8> DEFAULT_NEXT_TABLE_IDS = ImmutableList.of();
    private final List<U8> nextTableIds;
    static final OFTableFeaturePropNextTablesMissVer14 DEFAULT = new OFTableFeaturePropNextTablesMissVer14(DEFAULT_NEXT_TABLE_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropNextTablesMissVer14Funnel FUNNEL = new OFTableFeaturePropNextTablesMissVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropNextTablesMissVer14(List<U8> nextTableIds) {
        if (nextTableIds == null) {
            throw new NullPointerException("OFTableFeaturePropNextTablesMissVer14: property nextTableIds cannot be null");
        }
        this.nextTableIds = nextTableIds;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public List<U8> getNextTableIds() {
        return this.nextTableIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableFeaturePropNextTablesMiss.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropNextTablesMissVer14(");
        b.append("nextTableIds=").append(this.nextTableIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropNextTablesMissVer14 other = (OFTableFeaturePropNextTablesMissVer14)obj;
        return !(this.nextTableIds == null ? other.nextTableIds != null : !this.nextTableIds.equals(other.nextTableIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nextTableIds == null ? 0 : this.nextTableIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropNextTablesMissVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableFeaturePropNextTablesMissVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(3);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.nextTableIds);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropNextTablesMissVer14Funnel
    implements Funnel<OFTableFeaturePropNextTablesMissVer14> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropNextTablesMissVer14Funnel() {
        }

        public void funnel(OFTableFeaturePropNextTablesMissVer14 message, PrimitiveSink sink) {
            sink.putShort((short)3);
            FunnelUtils.putList(message.nextTableIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropNextTablesMiss> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropNextTablesMiss readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=0x3(0x3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U8> nextTableIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U8.READER);
            OFTableFeaturePropNextTablesMissVer14 tableFeaturePropNextTablesMissVer14 = new OFTableFeaturePropNextTablesMissVer14(nextTableIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropNextTablesMissVer14);
            }
            return tableFeaturePropNextTablesMissVer14;
        }
    }

    static class Builder
    implements OFTableFeaturePropNextTablesMiss.Builder {
        private boolean nextTableIdsSet;
        private List<U8> nextTableIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public List<U8> getNextTableIds() {
            return this.nextTableIds;
        }

        @Override
        public OFTableFeaturePropNextTablesMiss.Builder setNextTableIds(List<U8> nextTableIds) {
            this.nextTableIds = nextTableIds;
            this.nextTableIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropNextTablesMiss build() {
            List<U8> nextTableIds;
            List<U8> list = nextTableIds = this.nextTableIdsSet ? this.nextTableIds : DEFAULT_NEXT_TABLE_IDS;
            if (nextTableIds == null) {
                throw new NullPointerException("Property nextTableIds must not be null");
            }
            return new OFTableFeaturePropNextTablesMissVer14(nextTableIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropNextTablesMiss.Builder {
        final OFTableFeaturePropNextTablesMissVer14 parentMessage;
        private boolean nextTableIdsSet;
        private List<U8> nextTableIds;

        BuilderWithParent(OFTableFeaturePropNextTablesMissVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public List<U8> getNextTableIds() {
            return this.nextTableIds;
        }

        @Override
        public OFTableFeaturePropNextTablesMiss.Builder setNextTableIds(List<U8> nextTableIds) {
            this.nextTableIds = nextTableIds;
            this.nextTableIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropNextTablesMiss build() {
            List nextTableIds;
            List list = nextTableIds = this.nextTableIdsSet ? this.nextTableIds : this.parentMessage.nextTableIds;
            if (nextTableIds == null) {
                throw new NullPointerException("Property nextTableIds must not be null");
            }
            return new OFTableFeaturePropNextTablesMissVer14(nextTableIds);
        }
    }
}

