/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropWriteActions;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionId;
import org.projectfloodlight.openflow.protocol.ver14.OFActionIdVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropWriteActionsVer14
implements OFTableFeaturePropWriteActions {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropWriteActionsVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final List<OFActionId> DEFAULT_ACTION_IDS = ImmutableList.of();
    private final List<OFActionId> actionIds;
    static final OFTableFeaturePropWriteActionsVer14 DEFAULT = new OFTableFeaturePropWriteActionsVer14(DEFAULT_ACTION_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropWriteActionsVer14Funnel FUNNEL = new OFTableFeaturePropWriteActionsVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropWriteActionsVer14(List<OFActionId> actionIds) {
        if (actionIds == null) {
            throw new NullPointerException("OFTableFeaturePropWriteActionsVer14: property actionIds cannot be null");
        }
        this.actionIds = actionIds;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public List<OFActionId> getActionIds() {
        return this.actionIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableFeaturePropWriteActions.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropWriteActionsVer14(");
        b.append("actionIds=").append(this.actionIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropWriteActionsVer14 other = (OFTableFeaturePropWriteActionsVer14)obj;
        return !(this.actionIds == null ? other.actionIds != null : !this.actionIds.equals(other.actionIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionIds == null ? 0 : this.actionIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropWriteActionsVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableFeaturePropWriteActionsVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.actionIds);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropWriteActionsVer14Funnel
    implements Funnel<OFTableFeaturePropWriteActionsVer14> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropWriteActionsVer14Funnel() {
        }

        public void funnel(OFTableFeaturePropWriteActionsVer14 message, PrimitiveSink sink) {
            sink.putShort((short)4);
            FunnelUtils.putList(message.actionIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropWriteActions> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropWriteActions readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=0x4(0x4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFActionId> actionIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFActionIdVer14.READER);
            OFTableFeaturePropWriteActionsVer14 tableFeaturePropWriteActionsVer14 = new OFTableFeaturePropWriteActionsVer14(actionIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropWriteActionsVer14);
            }
            return tableFeaturePropWriteActionsVer14;
        }
    }

    static class Builder
    implements OFTableFeaturePropWriteActions.Builder {
        private boolean actionIdsSet;
        private List<OFActionId> actionIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public List<OFActionId> getActionIds() {
            return this.actionIds;
        }

        @Override
        public OFTableFeaturePropWriteActions.Builder setActionIds(List<OFActionId> actionIds) {
            this.actionIds = actionIds;
            this.actionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropWriteActions build() {
            List<OFActionId> actionIds;
            List<OFActionId> list = actionIds = this.actionIdsSet ? this.actionIds : DEFAULT_ACTION_IDS;
            if (actionIds == null) {
                throw new NullPointerException("Property actionIds must not be null");
            }
            return new OFTableFeaturePropWriteActionsVer14(actionIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropWriteActions.Builder {
        final OFTableFeaturePropWriteActionsVer14 parentMessage;
        private boolean actionIdsSet;
        private List<OFActionId> actionIds;

        BuilderWithParent(OFTableFeaturePropWriteActionsVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public List<OFActionId> getActionIds() {
            return this.actionIds;
        }

        @Override
        public OFTableFeaturePropWriteActions.Builder setActionIds(List<OFActionId> actionIds) {
            this.actionIds = actionIds;
            this.actionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropWriteActions build() {
            List actionIds;
            List list = actionIds = this.actionIdsSet ? this.actionIds : this.parentMessage.actionIds;
            if (actionIds == null) {
                throw new NullPointerException("Property actionIds must not be null");
            }
            return new OFTableFeaturePropWriteActionsVer14(actionIds);
        }
    }
}

