/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropWriteSetfieldMiss;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropWriteSetfieldMissVer14
implements OFTableFeaturePropWriteSetfieldMiss {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropWriteSetfieldMissVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final List<U32> DEFAULT_OXM_IDS = ImmutableList.of();
    private final List<U32> oxmIds;
    static final OFTableFeaturePropWriteSetfieldMissVer14 DEFAULT = new OFTableFeaturePropWriteSetfieldMissVer14(DEFAULT_OXM_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropWriteSetfieldMissVer14Funnel FUNNEL = new OFTableFeaturePropWriteSetfieldMissVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropWriteSetfieldMissVer14(List<U32> oxmIds) {
        if (oxmIds == null) {
            throw new NullPointerException("OFTableFeaturePropWriteSetfieldMissVer14: property oxmIds cannot be null");
        }
        this.oxmIds = oxmIds;
    }

    @Override
    public int getType() {
        return 13;
    }

    @Override
    public List<U32> getOxmIds() {
        return this.oxmIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableFeaturePropWriteSetfieldMiss.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropWriteSetfieldMissVer14(");
        b.append("oxmIds=").append(this.oxmIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropWriteSetfieldMissVer14 other = (OFTableFeaturePropWriteSetfieldMissVer14)obj;
        return !(this.oxmIds == null ? other.oxmIds != null : !this.oxmIds.equals(other.oxmIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oxmIds == null ? 0 : this.oxmIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropWriteSetfieldMissVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableFeaturePropWriteSetfieldMissVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(13);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.oxmIds);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropWriteSetfieldMissVer14Funnel
    implements Funnel<OFTableFeaturePropWriteSetfieldMissVer14> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropWriteSetfieldMissVer14Funnel() {
        }

        public void funnel(OFTableFeaturePropWriteSetfieldMissVer14 message, PrimitiveSink sink) {
            sink.putShort((short)13);
            FunnelUtils.putList(message.oxmIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropWriteSetfieldMiss> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropWriteSetfieldMiss readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 13) {
                throw new OFParseError("Wrong type: Expected=0xd(0xd), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U32> oxmIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U32.READER);
            OFTableFeaturePropWriteSetfieldMissVer14 tableFeaturePropWriteSetfieldMissVer14 = new OFTableFeaturePropWriteSetfieldMissVer14(oxmIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropWriteSetfieldMissVer14);
            }
            return tableFeaturePropWriteSetfieldMissVer14;
        }
    }

    static class Builder
    implements OFTableFeaturePropWriteSetfieldMiss.Builder {
        private boolean oxmIdsSet;
        private List<U32> oxmIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 13;
        }

        @Override
        public List<U32> getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFTableFeaturePropWriteSetfieldMiss.Builder setOxmIds(List<U32> oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropWriteSetfieldMiss build() {
            List<U32> oxmIds;
            List<U32> list = oxmIds = this.oxmIdsSet ? this.oxmIds : DEFAULT_OXM_IDS;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFTableFeaturePropWriteSetfieldMissVer14(oxmIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropWriteSetfieldMiss.Builder {
        final OFTableFeaturePropWriteSetfieldMissVer14 parentMessage;
        private boolean oxmIdsSet;
        private List<U32> oxmIds;

        BuilderWithParent(OFTableFeaturePropWriteSetfieldMissVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 13;
        }

        @Override
        public List<U32> getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFTableFeaturePropWriteSetfieldMiss.Builder setOxmIds(List<U32> oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropWriteSetfieldMiss build() {
            List oxmIds;
            List list = oxmIds = this.oxmIdsSet ? this.oxmIds : this.parentMessage.oxmIds;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFTableFeaturePropWriteSetfieldMissVer14(oxmIds);
        }
    }
}

