/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFUint64;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFUint64Ver14
implements OFUint64 {
    private static final Logger logger = LoggerFactory.getLogger(OFUint64Ver14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFUint64Ver14 DEFAULT = new OFUint64Ver14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFUint64Ver14Funnel FUNNEL = new OFUint64Ver14Funnel();
    static final Writer WRITER = new Writer();

    OFUint64Ver14(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFUint64Ver14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFUint64.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFUint64Ver14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFUint64Ver14 other = (OFUint64Ver14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFUint64Ver14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFUint64Ver14 message) {
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFUint64Ver14Funnel
    implements Funnel<OFUint64Ver14> {
        private static final long serialVersionUID = 1L;

        OFUint64Ver14Funnel() {
        }

        public void funnel(OFUint64Ver14 message, PrimitiveSink sink) {
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFUint64> {
        Reader() {
        }

        @Override
        public OFUint64 readFrom(ChannelBuffer bb) throws OFParseError {
            U64 value = U64.ofRaw(bb.readLong());
            OFUint64Ver14 uint64Ver14 = new OFUint64Ver14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)uint64Ver14);
            }
            return uint64Ver14;
        }
    }

    static class Builder
    implements OFUint64.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFUint64.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFUint64 build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFUint64Ver14(value);
        }
    }

    static class BuilderWithParent
    implements OFUint64.Builder {
        final OFUint64Ver14 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFUint64Ver14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFUint64.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFUint64 build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFUint64Ver14(value);
        }
    }
}

