/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.base.Preconditions;
import org.projectfloodlight.openflow.types.IPAddress;
import org.projectfloodlight.openflow.types.IPVersion;
import org.projectfloodlight.openflow.types.IPv4AddressWithMask;
import org.projectfloodlight.openflow.types.IPv6AddressWithMask;
import org.projectfloodlight.openflow.types.Masked;

public abstract class IPAddressWithMask<F extends IPAddress<F>>
extends Masked<F> {
    protected IPAddressWithMask(F value, F mask) {
        super(value, mask);
    }

    public abstract IPVersion getIpVersion();

    public abstract boolean contains(IPAddress<?> var1);

    public F getSubnetBroadcastAddress() {
        if (!((IPAddress)this.mask).isCidrMask()) {
            throw new IllegalArgumentException("Mask Invalid " + this.mask + " cannot get subnet for non CIDR mask");
        }
        return ((IPAddress)this.value).or(((IPAddress)this.mask).not());
    }

    public boolean isSubnetBroadcastAddress(F candidate) {
        return ((IPAddress)this.getSubnetBroadcastAddress()).equals(candidate);
    }

    public static IPAddressWithMask<?> of(String ip) {
        Preconditions.checkNotNull((Object)ip, (Object)"string ip must not be null");
        if (ip.indexOf(46) != -1) {
            return IPv4AddressWithMask.of(ip);
        }
        if (ip.indexOf(58) != -1) {
            return IPv6AddressWithMask.of(ip);
        }
        throw new IllegalArgumentException("IP Address not well formed: " + ip);
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(((IPAddress)this.value).toString());
        res.append('/');
        if (((IPAddress)this.mask).isCidrMask()) {
            res.append(((IPAddress)this.mask).asCidrMaskLength());
        } else {
            res.append(((IPAddress)this.mask).toString());
        }
        return res.toString();
    }
}

