/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.projectfloodlight.openflow.types.IPAddress;
import org.projectfloodlight.openflow.types.IPAddressWithMask;
import org.projectfloodlight.openflow.types.IPVersion;
import org.projectfloodlight.openflow.types.IPv4Address;

public class IPv4AddressWithMask
extends IPAddressWithMask<IPv4Address> {
    public static final IPv4AddressWithMask NONE = IPv4AddressWithMask.of(IPv4Address.NONE, IPv4Address.NONE);

    private IPv4AddressWithMask(int rawValue, int rawMask) {
        super(IPv4Address.of(rawValue), IPv4Address.of(rawMask));
    }

    private IPv4AddressWithMask(IPv4Address value, IPv4Address mask) {
        super(value, mask);
    }

    @Override
    public IPVersion getIpVersion() {
        return IPVersion.IPv4;
    }

    @Nonnull
    @Deprecated
    public static IPv4AddressWithMask of(int rawValue, int rawMask) {
        return new IPv4AddressWithMask(rawValue, rawMask);
    }

    @Nonnull
    public static IPv4AddressWithMask of(@Nonnull IPv4Address value, @Nonnull IPv4Address mask) {
        Preconditions.checkNotNull((Object)value, (Object)"value must not be null");
        Preconditions.checkNotNull((Object)mask, (Object)"mask must not be null");
        return new IPv4AddressWithMask(value, mask);
    }

    @Nonnull
    public static IPv4AddressWithMask of(@Nonnull String string) {
        Preconditions.checkNotNull((Object)string, (Object)"string must not be null");
        String ip = string;
        int cidrMaskLength = 32;
        IPv4Address maskAddress = null;
        int slashPos = string.indexOf(47);
        if (slashPos != -1) {
            ip = string.substring(0, slashPos);
            try {
                String suffix = string.substring(slashPos + 1);
                if (suffix.length() == 0) {
                    throw new IllegalArgumentException("IP Address not well formed: " + string);
                }
                if (suffix.indexOf(46) != -1) {
                    maskAddress = IPv4Address.of(suffix);
                } else {
                    cidrMaskLength = Integer.parseInt(suffix);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("IP Address not well formed: " + string);
            }
        }
        IPv4Address ipv4 = IPv4Address.of(ip);
        if (maskAddress != null) {
            return IPv4AddressWithMask.of(ipv4, maskAddress);
        }
        return IPv4AddressWithMask.of(ipv4, IPv4Address.ofCidrMaskLength(cidrMaskLength));
    }

    @Override
    public boolean contains(IPAddress<?> ip) {
        Preconditions.checkNotNull(ip, (Object)"ip must not be null");
        if (ip.getIpVersion() == IPVersion.IPv4) {
            IPv4Address ipv4 = (IPv4Address)ip;
            return this.matches(ipv4);
        }
        return false;
    }
}

