/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.types.OFValueType;

public class OFBitMask128
implements OFValueType<OFBitMask128> {
    static final int LENGTH = 16;
    private final long raw1;
    private final long raw2;
    public static final OFBitMask128 ALL = new OFBitMask128(-1L, -1L);
    public static final OFBitMask128 NONE = new OFBitMask128(0L, 0L);
    public static final OFBitMask128 NO_MASK = ALL;
    public static final OFBitMask128 FULL_MASK = NONE;

    private OFBitMask128(long raw1, long raw2) {
        this.raw1 = raw1;
        this.raw2 = raw2;
    }

    public static OFBitMask128 of(long raw1, long raw2) {
        if (raw1 == -1L && raw2 == -1L) {
            return ALL;
        }
        if (raw1 == 0L && raw2 == 0L) {
            return NONE;
        }
        return new OFBitMask128(raw1, raw2);
    }

    @Override
    public int getLength() {
        return 16;
    }

    @Override
    public OFBitMask128 applyMask(OFBitMask128 mask) {
        return OFBitMask128.of(this.raw1 & mask.raw1, this.raw2 & mask.raw2);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OFBitMask128)) {
            return false;
        }
        OFBitMask128 other = (OFBitMask128)obj;
        return other.raw1 == this.raw1 && other.raw2 == this.raw2;
    }

    public int hashCode() {
        return (int)(31L * this.raw1 + this.raw2);
    }

    protected static boolean isBitOn(long raw1, long raw2, int bit) {
        long word;
        if (bit < 0 || bit >= 128) {
            throw new IndexOutOfBoundsException();
        }
        if (bit < 64) {
            word = raw2;
        } else {
            word = raw1;
            bit -= 64;
        }
        return (word & 1L << bit) != 0L;
    }

    public void write16Bytes(ChannelBuffer cb) {
        cb.writeLong(this.raw1);
        cb.writeLong(this.raw2);
    }

    public static OFBitMask128 read16Bytes(ChannelBuffer cb) {
        long raw1 = cb.readLong();
        long raw2 = cb.readLong();
        return OFBitMask128.of(raw1, raw2);
    }

    public boolean isOn(int bit) {
        return OFBitMask128.isBitOn(this.raw1, this.raw2, bit);
    }

    public String toString() {
        return (String.format("%64s", Long.toBinaryString(this.raw2)) + String.format("%64s", Long.toBinaryString(this.raw1))).replaceAll(" ", "0");
    }

    @Override
    public int compareTo(OFBitMask128 o) {
        long c = this.raw1 - o.raw1;
        if (c != 0L) {
            return Long.signum(c);
        }
        return Long.signum(this.raw2 - o.raw2);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putLong(this.raw1);
        sink.putLong(this.raw2);
    }
}

