/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.types.OFValueType;

public class OFBitMask512
implements OFValueType<OFBitMask512> {
    static final int LENGTH = 64;
    private final long raw1;
    private final long raw2;
    private final long raw3;
    private final long raw4;
    private final long raw5;
    private final long raw6;
    private final long raw7;
    private final long raw8;
    public static final OFBitMask512 ALL = new OFBitMask512(-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L);
    public static final OFBitMask512 NONE = new OFBitMask512(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    public static final OFBitMask512 NO_MASK = ALL;
    public static final OFBitMask512 FULL_MASK = NONE;

    private OFBitMask512(long raw1, long raw2, long raw3, long raw4, long raw5, long raw6, long raw7, long raw8) {
        this.raw1 = raw1;
        this.raw2 = raw2;
        this.raw3 = raw3;
        this.raw4 = raw4;
        this.raw5 = raw5;
        this.raw6 = raw6;
        this.raw7 = raw7;
        this.raw8 = raw8;
    }

    public static OFBitMask512 of(long raw1, long raw2, long raw3, long raw4, long raw5, long raw6, long raw7, long raw8) {
        if (raw1 == -1L && raw2 == -1L && raw3 == -1L && raw4 == -1L && raw5 == -1L && raw6 == -1L && raw7 == -1L && raw8 == -1L) {
            return ALL;
        }
        if (raw1 == 0L && raw2 == 0L && raw3 == 0L && raw4 == 0L && raw5 == 0L && raw6 == 0L && raw7 == 0L && raw8 == 0L) {
            return NONE;
        }
        return new OFBitMask512(raw1, raw2, raw3, raw4, raw5, raw6, raw7, raw8);
    }

    @Override
    public int getLength() {
        return 64;
    }

    @Override
    public OFBitMask512 applyMask(OFBitMask512 mask) {
        return OFBitMask512.of(this.raw1 & mask.raw1, this.raw2 & mask.raw2, this.raw3 & mask.raw3, this.raw4 & mask.raw4, this.raw5 & mask.raw5, this.raw6 & mask.raw6, this.raw7 & mask.raw7, this.raw8 & mask.raw8);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.raw1 ^ this.raw1 >>> 32);
        result = 31 * result + (int)(this.raw2 ^ this.raw2 >>> 32);
        result = 31 * result + (int)(this.raw3 ^ this.raw3 >>> 32);
        result = 31 * result + (int)(this.raw4 ^ this.raw4 >>> 32);
        result = 31 * result + (int)(this.raw5 ^ this.raw5 >>> 32);
        result = 31 * result + (int)(this.raw6 ^ this.raw6 >>> 32);
        result = 31 * result + (int)(this.raw7 ^ this.raw7 >>> 32);
        result = 31 * result + (int)(this.raw8 ^ this.raw8 >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBitMask512 other = (OFBitMask512)obj;
        if (this.raw1 != other.raw1) {
            return false;
        }
        if (this.raw2 != other.raw2) {
            return false;
        }
        if (this.raw3 != other.raw3) {
            return false;
        }
        if (this.raw4 != other.raw4) {
            return false;
        }
        if (this.raw5 != other.raw5) {
            return false;
        }
        if (this.raw6 != other.raw6) {
            return false;
        }
        if (this.raw7 != other.raw7) {
            return false;
        }
        return this.raw8 == other.raw8;
    }

    protected static boolean isBitOn(long raw1, long raw2, long raw3, long raw4, long raw5, long raw6, long raw7, long raw8, int bit) {
        long word;
        if (bit < 0 || bit >= 512) {
            throw new IndexOutOfBoundsException();
        }
        if (bit < 64) {
            word = raw8;
        } else if (bit < 128) {
            word = raw7;
            bit -= 64;
        } else if (bit < 192) {
            word = raw6;
            bit -= 128;
        } else if (bit < 256) {
            word = raw5;
            bit -= 192;
        } else if (bit < 320) {
            word = raw4;
            bit -= 256;
        } else if (bit < 384) {
            word = raw3;
            bit -= 320;
        } else if (bit < 448) {
            word = raw2;
            bit -= 384;
        } else {
            word = raw1;
            bit -= 448;
        }
        return (word & 1L << bit) != 0L;
    }

    public void write64Bytes(ChannelBuffer cb) {
        cb.writeLong(this.raw1);
        cb.writeLong(this.raw2);
        cb.writeLong(this.raw3);
        cb.writeLong(this.raw4);
        cb.writeLong(this.raw5);
        cb.writeLong(this.raw6);
        cb.writeLong(this.raw7);
        cb.writeLong(this.raw8);
    }

    public static OFBitMask512 read64Bytes(ChannelBuffer cb) {
        long raw1 = cb.readLong();
        long raw2 = cb.readLong();
        long raw3 = cb.readLong();
        long raw4 = cb.readLong();
        long raw5 = cb.readLong();
        long raw6 = cb.readLong();
        long raw7 = cb.readLong();
        long raw8 = cb.readLong();
        return OFBitMask512.of(raw1, raw2, raw3, raw4, raw5, raw6, raw7, raw8);
    }

    public boolean isOn(int bit) {
        return OFBitMask512.isBitOn(this.raw1, this.raw2, this.raw3, this.raw4, this.raw5, this.raw6, this.raw7, this.raw8, bit);
    }

    public String toString() {
        return (String.format("%64s", Long.toBinaryString(this.raw8)) + String.format("%64s", Long.toBinaryString(this.raw7)) + String.format("%64s", Long.toBinaryString(this.raw6)) + String.format("%64s", Long.toBinaryString(this.raw5)) + String.format("%64s", Long.toBinaryString(this.raw4)) + String.format("%64s", Long.toBinaryString(this.raw3)) + String.format("%64s", Long.toBinaryString(this.raw2)) + String.format("%64s", Long.toBinaryString(this.raw1))).replaceAll(" ", "0");
    }

    @Override
    public int compareTo(OFBitMask512 o) {
        long c = this.raw1 - o.raw1;
        if (c != 0L) {
            return Long.signum(c);
        }
        c = this.raw2 - o.raw2;
        if (c != 0L) {
            return Long.signum(c);
        }
        c = this.raw3 - o.raw3;
        if (c != 0L) {
            return Long.signum(c);
        }
        c = this.raw4 - o.raw4;
        if (c != 0L) {
            return Long.signum(c);
        }
        c = this.raw5 - o.raw5;
        if (c != 0L) {
            return Long.signum(c);
        }
        c = this.raw6 - o.raw6;
        if (c != 0L) {
            return Long.signum(c);
        }
        c = this.raw7 - o.raw7;
        if (c != 0L) {
            return Long.signum(c);
        }
        return Long.signum(this.raw8 - o.raw8);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putLong(this.raw1);
        sink.putLong(this.raw2);
        sink.putLong(this.raw3);
        sink.putLong(this.raw4);
        sink.putLong(this.raw5);
        sink.putLong(this.raw6);
        sink.putLong(this.raw7);
        sink.putLong(this.raw8);
    }
}

