/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Ints;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

public class TransportPort
implements OFValueType<TransportPort> {
    static final int LENGTH = 2;
    static final int MAX_PORT = 65535;
    static final int MIN_PORT = 0;
    private static final int NONE_VAL = 0;
    public static final TransportPort NONE = new TransportPort(0);
    public static final TransportPort NO_MASK = new TransportPort(-1);
    public static final TransportPort FULL_MASK = TransportPort.of(0);
    private final int port;

    private TransportPort(int port) {
        this.port = port;
    }

    public static TransportPort of(int port) {
        if (port == 0) {
            return NONE;
        }
        if (port == TransportPort.NO_MASK.port) {
            return NO_MASK;
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Illegal transport layer port number: " + port);
        }
        return new TransportPort(port);
    }

    @Override
    public int getLength() {
        return 2;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransportPort)) {
            return false;
        }
        TransportPort other = (TransportPort)obj;
        return other.port == this.port;
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        result = 59 * result + this.port;
        return result;
    }

    public String toString() {
        return Integer.toString(this.port);
    }

    public void write2Bytes(ChannelBuffer c) {
        c.writeShort(this.port);
    }

    public static TransportPort read2Bytes(ChannelBuffer c) throws OFParseError {
        return TransportPort.of(c.readUnsignedShort() & 0xFFFF);
    }

    @Override
    public TransportPort applyMask(TransportPort mask) {
        return TransportPort.of(this.port & mask.port);
    }

    @Override
    public int compareTo(TransportPort o) {
        return Ints.compare((int)this.port, (int)o.port);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putShort((short)this.port);
    }
}

