/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import javax.annotation.concurrent.Immutable;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.types.OFValueType;

@Immutable
public class UDF
implements OFValueType<UDF> {
    static final int LENGTH = 4;
    private final int rawValue;
    public static final UDF ZERO = UDF.of(0);
    public static final UDF NO_MASK = UDF.of(-1);
    public static final UDF FULL_MASK = UDF.of(0);

    private UDF(int rawValue) {
        this.rawValue = rawValue;
    }

    public static UDF of(int raw) {
        return new UDF(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public int getLength() {
        return 4;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rawValue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UDF other = (UDF)obj;
        return this.rawValue == other.rawValue;
    }

    public String toString() {
        return Integer.toString(this.rawValue);
    }

    public void write4Bytes(ChannelBuffer c) {
        c.writeInt(this.rawValue);
    }

    public static UDF read4Bytes(ChannelBuffer c) {
        return UDF.of(c.readInt());
    }

    @Override
    public UDF applyMask(UDF mask) {
        return UDF.of(this.rawValue & mask.rawValue);
    }

    @Override
    public int compareTo(UDF o) {
        return UnsignedInts.compare((int)this.rawValue, (int)o.rawValue);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.rawValue);
    }
}

