// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFPortDescPropOpticalTransportVer13 implements OFPortDescPropOpticalTransport {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropOpticalTransportVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 8;

        private final static int DEFAULT_TYPE = 0x0;
        private final static short DEFAULT_PORT_SIGNAL_TYPE = (short) 0x0;
        private final static short DEFAULT_RESERVED = (short) 0x0;
        private final static short DEFAULT_PORT_TYPE = (short) 0x0;

    // OF message fields
    private final int type;
    private final short portSignalType;
    private final short reserved;
    private final short portType;
//
    // Immutable default instance
    final static OFPortDescPropOpticalTransportVer13 DEFAULT = new OFPortDescPropOpticalTransportVer13(
        DEFAULT_TYPE, DEFAULT_PORT_SIGNAL_TYPE, DEFAULT_RESERVED, DEFAULT_PORT_TYPE
    );

    // package private constructor - used by readers, builders, and factory
    OFPortDescPropOpticalTransportVer13(int type, short portSignalType, short reserved, short portType) {
        this.type = type;
        this.portSignalType = portSignalType;
        this.reserved = reserved;
        this.portType = portType;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return type;
    }

    @Override
    public short getPortSignalType() {
        return portSignalType;
    }

    @Override
    public short getReserved() {
        return reserved;
    }

    @Override
    public short getPortType() {
        return portType;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFPortDescPropOpticalTransport.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFPortDescPropOpticalTransport.Builder {
        final OFPortDescPropOpticalTransportVer13 parentMessage;

        // OF message fields
        private boolean typeSet;
        private int type;
        private boolean portSignalTypeSet;
        private short portSignalType;
        private boolean reservedSet;
        private short reserved;
        private boolean portTypeSet;
        private short portType;

        BuilderWithParent(OFPortDescPropOpticalTransportVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return type;
    }

    @Override
    public OFPortDescPropOpticalTransport.Builder setType(int type) {
        this.type = type;
        this.typeSet = true;
        return this;
    }
    @Override
    public short getPortSignalType() {
        return portSignalType;
    }

    @Override
    public OFPortDescPropOpticalTransport.Builder setPortSignalType(short portSignalType) {
        this.portSignalType = portSignalType;
        this.portSignalTypeSet = true;
        return this;
    }
    @Override
    public short getReserved() {
        return reserved;
    }

    @Override
    public OFPortDescPropOpticalTransport.Builder setReserved(short reserved) {
        this.reserved = reserved;
        this.reservedSet = true;
        return this;
    }
    @Override
    public short getPortType() {
        return portType;
    }

    @Override
    public OFPortDescPropOpticalTransport.Builder setPortType(short portType) {
        this.portType = portType;
        this.portTypeSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFPortDescPropOpticalTransport build() {
                int type = this.typeSet ? this.type : parentMessage.type;
                short portSignalType = this.portSignalTypeSet ? this.portSignalType : parentMessage.portSignalType;
                short reserved = this.reservedSet ? this.reserved : parentMessage.reserved;
                short portType = this.portTypeSet ? this.portType : parentMessage.portType;

                //
                return new OFPortDescPropOpticalTransportVer13(
                    type,
                    portSignalType,
                    reserved,
                    portType
                );
        }

    }

    static class Builder implements OFPortDescPropOpticalTransport.Builder {
        // OF message fields
        private boolean typeSet;
        private int type;
        private boolean portSignalTypeSet;
        private short portSignalType;
        private boolean reservedSet;
        private short reserved;
        private boolean portTypeSet;
        private short portType;

    @Override
    public int getType() {
        return type;
    }

    @Override
    public OFPortDescPropOpticalTransport.Builder setType(int type) {
        this.type = type;
        this.typeSet = true;
        return this;
    }
    @Override
    public short getPortSignalType() {
        return portSignalType;
    }

    @Override
    public OFPortDescPropOpticalTransport.Builder setPortSignalType(short portSignalType) {
        this.portSignalType = portSignalType;
        this.portSignalTypeSet = true;
        return this;
    }
    @Override
    public short getReserved() {
        return reserved;
    }

    @Override
    public OFPortDescPropOpticalTransport.Builder setReserved(short reserved) {
        this.reserved = reserved;
        this.reservedSet = true;
        return this;
    }
    @Override
    public short getPortType() {
        return portType;
    }

    @Override
    public OFPortDescPropOpticalTransport.Builder setPortType(short portType) {
        this.portType = portType;
        this.portTypeSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFPortDescPropOpticalTransport build() {
            int type = this.typeSet ? this.type : DEFAULT_TYPE;
            short portSignalType = this.portSignalTypeSet ? this.portSignalType : DEFAULT_PORT_SIGNAL_TYPE;
            short reserved = this.reservedSet ? this.reserved : DEFAULT_RESERVED;
            short portType = this.portTypeSet ? this.portType : DEFAULT_PORT_TYPE;


            return new OFPortDescPropOpticalTransportVer13(
                    type,
                    portSignalType,
                    reserved,
                    portType
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFPortDescPropOpticalTransport> {
        @Override
        public OFPortDescPropOpticalTransport readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int type = U16.f(bb.readShort());
            int length = U16.f(bb.readShort());
            if(length != 8)
                throw new OFParseError("Wrong length: Expected=8(8), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            short portSignalType = U8.f(bb.readByte());
            short reserved = U8.f(bb.readByte());
            // pad: 1 bytes
            bb.skipBytes(1);
            short portType = U8.f(bb.readByte());

            OFPortDescPropOpticalTransportVer13 portDescPropOpticalTransportVer13 = new OFPortDescPropOpticalTransportVer13(
                    type,
                      portSignalType,
                      reserved,
                      portType
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", portDescPropOpticalTransportVer13);
            return portDescPropOpticalTransportVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFPortDescPropOpticalTransportVer13Funnel FUNNEL = new OFPortDescPropOpticalTransportVer13Funnel();
    static class OFPortDescPropOpticalTransportVer13Funnel implements Funnel<OFPortDescPropOpticalTransportVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFPortDescPropOpticalTransportVer13 message, PrimitiveSink sink) {
            sink.putInt(message.type);
            // fixed value property length = 8
            sink.putShort((short) 0x8);
            sink.putShort(message.portSignalType);
            sink.putShort(message.reserved);
            // skip pad (1 bytes)
            sink.putShort(message.portType);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFPortDescPropOpticalTransportVer13> {
        @Override
        public void write(ChannelBuffer bb, OFPortDescPropOpticalTransportVer13 message) {
            bb.writeShort(U16.t(message.type));
            // fixed value property length = 8
            bb.writeShort((short) 0x8);
            bb.writeByte(U8.t(message.portSignalType));
            bb.writeByte(U8.t(message.reserved));
            // pad: 1 bytes
            bb.writeZero(1);
            bb.writeByte(U8.t(message.portType));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropOpticalTransportVer13(");
        b.append("type=").append(type);
        b.append(", ");
        b.append("portSignalType=").append(portSignalType);
        b.append(", ");
        b.append("reserved=").append(reserved);
        b.append(", ");
        b.append("portType=").append(portType);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFPortDescPropOpticalTransportVer13 other = (OFPortDescPropOpticalTransportVer13) obj;

        if( type != other.type)
            return false;
        if( portSignalType != other.portSignalType)
            return false;
        if( reserved != other.reserved)
            return false;
        if( portType != other.portType)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + type;
        result = prime * result + portSignalType;
        result = prime * result + reserved;
        result = prime * result + portType;
        return result;
    }

}
