/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPortStatusVer10;

public class OFPortStatusVer10Test {
    OFFactory factory;
    static final byte[] PORT_STATUS_SERIALIZED = new byte[]{1, 12, 0, 64, 0, 0, 0, 4, 1, 0, 0, 0, 0, 0, 0, 0, -1, -3, 1, 2, 3, 4, 5, 6, 102, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 2, 0, 0, 0, 0, 1, 0, 0, 0, 32, 0, 0, 2, 0, 0, 0, 8, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer10.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])PORT_STATUS_SERIALIZED);
        OFPortStatus portStatus = OFPortStatusVer10.READER.readFrom(input);
        Assert.assertEquals((long)PORT_STATUS_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        portStatus.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_STATUS_SERIALIZED));
    }
}

