/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnGentableEntryAdd;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnGentableEntryAddVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U128;

public class OFBsnGentableEntryAddVer13Test {
    OFFactory factory;
    static final byte[] BSN_GENTABLE_ENTRY_ADD_SERIALIZED = new byte[]{4, 4, 0, 72, 18, 52, 86, 120, 0, 92, 22, -57, 0, 0, 0, 46, 0, 20, 0, 18, -2, -36, -70, -104, 118, 84, 50, 16, -1, -18, -52, -69, -86, -103, -120, 119, 0, 0, 0, 8, 0, 0, 0, 5, 0, 1, 0, 10, 1, 35, 69, 103, -119, -85, 0, 0, 0, 8, 0, 0, 0, 6, 0, 1, 0, 10, -1, -18, -35, -52, -69, -86};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnGentableEntryAdd.Builder builder = this.factory.buildBsnGentableEntryAdd();
        builder.setXid(305419896L).setChecksum(U128.of((long)-81985529216486896L, (long)-4841443187652489L)).setTableId(GenTableId.of((int)20)).setKey((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)5)), (Object)this.factory.bsnTlvs().mac(MacAddress.of((String)"01:23:45:67:89:ab")))).setValue((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)6)), (Object)this.factory.bsnTlvs().mac(MacAddress.of((String)"ff:ee:dd:cc:bb:aa"))));
        OFBsnGentableEntryAdd bsnGentableEntryAdd = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnGentableEntryAdd.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_ENTRY_ADD_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnGentableEntryAdd.Builder builder = this.factory.buildBsnGentableEntryAdd();
        builder.setXid(305419896L).setChecksum(U128.of((long)-81985529216486896L, (long)-4841443187652489L)).setTableId(GenTableId.of((int)20)).setKey((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)5)), (Object)this.factory.bsnTlvs().mac(MacAddress.of((String)"01:23:45:67:89:ab")))).setValue((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)6)), (Object)this.factory.bsnTlvs().mac(MacAddress.of((String)"ff:ee:dd:cc:bb:aa"))));
        OFBsnGentableEntryAdd bsnGentableEntryAddBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_GENTABLE_ENTRY_ADD_SERIALIZED);
        OFBsnGentableEntryAdd bsnGentableEntryAddRead = OFBsnGentableEntryAddVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_ENTRY_ADD_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnGentableEntryAddBuilt, (Object)bsnGentableEntryAddRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_GENTABLE_ENTRY_ADD_SERIALIZED);
        OFBsnGentableEntryAdd bsnGentableEntryAdd = OFBsnGentableEntryAddVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_ENTRY_ADD_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnGentableEntryAdd.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_ENTRY_ADD_SERIALIZED));
    }
}

