/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFEchoReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFEchoReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;

public class OFEchoReplyVer13Test {
    OFFactory factory;
    static final byte[] ECHO_REPLY_SERIALIZED = new byte[]{4, 3, 0, 11, 18, 52, 86, 120, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])ECHO_REPLY_SERIALIZED);
        OFEchoReply echoReply = OFEchoReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)ECHO_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        echoReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ECHO_REPLY_SERIALIZED));
    }
}

