/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetTpSrc;
import org.projectfloodlight.openflow.types.TransportPort;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetTpSrcVer10
implements OFActionSetTpSrc {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetTpSrcVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 8;
    private static final TransportPort DEFAULT_TP_PORT = TransportPort.NONE;
    private final TransportPort tpPort;
    static final OFActionSetTpSrcVer10 DEFAULT = new OFActionSetTpSrcVer10(DEFAULT_TP_PORT);
    static final Reader READER = new Reader();
    static final OFActionSetTpSrcVer10Funnel FUNNEL = new OFActionSetTpSrcVer10Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetTpSrcVer10(TransportPort tpPort) {
        if (tpPort == null) {
            throw new NullPointerException("OFActionSetTpSrcVer10: property tpPort cannot be null");
        }
        this.tpPort = tpPort;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_TP_SRC;
    }

    @Override
    public TransportPort getTpPort() {
        return this.tpPort;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFActionSetTpSrc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetTpSrcVer10(");
        b.append("tpPort=").append(this.tpPort);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetTpSrcVer10 other = (OFActionSetTpSrcVer10)obj;
        return !(this.tpPort == null ? other.tpPort != null : !this.tpPort.equals(other.tpPort));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tpPort == null ? 0 : this.tpPort.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetTpSrcVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionSetTpSrcVer10 message) {
            bb.writeShort(9);
            bb.writeShort(8);
            message.tpPort.write2Bytes(bb);
            bb.writeZero(2);
        }
    }

    static class OFActionSetTpSrcVer10Funnel
    implements Funnel<OFActionSetTpSrcVer10> {
        private static final long serialVersionUID = 1L;

        OFActionSetTpSrcVer10Funnel() {
        }

        public void funnel(OFActionSetTpSrcVer10 message, PrimitiveSink sink) {
            sink.putShort((short)9);
            sink.putShort((short)8);
            message.tpPort.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetTpSrc> {
        Reader() {
        }

        @Override
        public OFActionSetTpSrc readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 9) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_TP_SRC(9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            TransportPort tpPort = TransportPort.read2Bytes(bb);
            bb.skipBytes(2);
            OFActionSetTpSrcVer10 actionSetTpSrcVer10 = new OFActionSetTpSrcVer10(tpPort);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetTpSrcVer10);
            }
            return actionSetTpSrcVer10;
        }
    }

    static class Builder
    implements OFActionSetTpSrc.Builder {
        private boolean tpPortSet;
        private TransportPort tpPort;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_TP_SRC;
        }

        @Override
        public TransportPort getTpPort() {
            return this.tpPort;
        }

        @Override
        public OFActionSetTpSrc.Builder setTpPort(TransportPort tpPort) {
            this.tpPort = tpPort;
            this.tpPortSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionSetTpSrc build() {
            TransportPort tpPort;
            TransportPort transportPort = tpPort = this.tpPortSet ? this.tpPort : DEFAULT_TP_PORT;
            if (tpPort == null) {
                throw new NullPointerException("Property tpPort must not be null");
            }
            return new OFActionSetTpSrcVer10(tpPort);
        }
    }

    static class BuilderWithParent
    implements OFActionSetTpSrc.Builder {
        final OFActionSetTpSrcVer10 parentMessage;
        private boolean tpPortSet;
        private TransportPort tpPort;

        BuilderWithParent(OFActionSetTpSrcVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_TP_SRC;
        }

        @Override
        public TransportPort getTpPort() {
            return this.tpPort;
        }

        @Override
        public OFActionSetTpSrc.Builder setTpPort(TransportPort tpPort) {
            this.tpPort = tpPort;
            this.tpPortSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionSetTpSrc build() {
            TransportPort tpPort;
            TransportPort transportPort = tpPort = this.tpPortSet ? this.tpPort : this.parentMessage.tpPort;
            if (tpPort == null) {
                throw new NullPointerException("Property tpPort must not be null");
            }
            return new OFActionSetTpSrcVer10(tpPort);
        }
    }
}

