/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver10.ChannelUtilsVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowAddVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowDeleteStrictVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowDeleteVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowModifyStrictVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowModifyVer10;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;

abstract class OFFlowModVer10 {
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 72;
    public static final Reader READER = new Reader();

    OFFlowModVer10() {
    }

    static class Reader
    implements OFMessageReader<OFFlowMod> {
        Reader() {
        }

        @Override
        public OFFlowMod readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 72) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 14) {
                throw new OFParseError("Wrong type: Expected=OFType.FLOW_MOD(14), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 72) {
                throw new OFParseError("Wrong length: Expected to be >= 72, was: " + length);
            }
            U32.f(bb.readInt());
            ChannelUtilsVer10.readOFMatch(bb);
            U64.ofRaw(bb.readLong());
            short command = bb.readShort();
            bb.readerIndex(start);
            switch (command) {
                case 0: {
                    return OFFlowAddVer10.READER.readFrom(bb);
                }
                case 3: {
                    return OFFlowDeleteVer10.READER.readFrom(bb);
                }
                case 4: {
                    return OFFlowDeleteStrictVer10.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowModifyVer10.READER.readFrom(bb);
                }
                case 2: {
                    return OFFlowModifyStrictVer10.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator command of class OFFlowModVer10: " + command);
        }
    }
}

