/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.ver10.OFAggregateStatsReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFDescStatsReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFExperimenterStatsReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowStatsReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPortStatsReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFQueueStatsReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFTableStatsReplyVer10;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsReplyVer10 {
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 12;
    public static final Reader READER = new Reader();

    OFStatsReplyVer10() {
    }

    static class Reader
    implements OFMessageReader<OFStatsReply> {
        Reader() {
        }

        @Override
        public OFStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 12) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 17) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(17), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsReplyVer10.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsReplyVer10.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsReplyVer10.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsReplyVer10.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsReplyVer10.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsReplyVer10.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsReplyVer10.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsReplyVer10: " + statsType);
        }
    }
}

