/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetQueue;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetQueueVer11
implements OFActionSetQueue {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetQueueVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private final long queueId;
    static final OFActionSetQueueVer11 DEFAULT = new OFActionSetQueueVer11(0L);
    static final Reader READER = new Reader();
    static final OFActionSetQueueVer11Funnel FUNNEL = new OFActionSetQueueVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetQueueVer11(long queueId) {
        this.queueId = queueId;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_QUEUE;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionSetQueue.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetQueueVer11(");
        b.append("queueId=").append(this.queueId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetQueueVer11 other = (OFActionSetQueueVer11)obj;
        return this.queueId == other.queueId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetQueueVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionSetQueueVer11 message) {
            bb.writeShort(21);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.queueId));
        }
    }

    static class OFActionSetQueueVer11Funnel
    implements Funnel<OFActionSetQueueVer11> {
        private static final long serialVersionUID = 1L;

        OFActionSetQueueVer11Funnel() {
        }

        public void funnel(OFActionSetQueueVer11 message, PrimitiveSink sink) {
            sink.putShort((short)21);
            sink.putShort((short)8);
            sink.putLong(message.queueId);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetQueue> {
        Reader() {
        }

        @Override
        public OFActionSetQueue readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 21) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_QUEUE(21), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long queueId = U32.f(bb.readInt());
            OFActionSetQueueVer11 actionSetQueueVer11 = new OFActionSetQueueVer11(queueId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetQueueVer11);
            }
            return actionSetQueueVer11;
        }
    }

    static class Builder
    implements OFActionSetQueue.Builder {
        private boolean queueIdSet;
        private long queueId;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_QUEUE;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFActionSetQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetQueue build() {
            long queueId = this.queueIdSet ? this.queueId : 0L;
            return new OFActionSetQueueVer11(queueId);
        }
    }

    static class BuilderWithParent
    implements OFActionSetQueue.Builder {
        final OFActionSetQueueVer11 parentMessage;
        private boolean queueIdSet;
        private long queueId;

        BuilderWithParent(OFActionSetQueueVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_QUEUE;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFActionSetQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetQueue build() {
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            return new OFActionSetQueueVer11(queueId);
        }
    }
}

