/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnBwEnableGetRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnBwEnableGetRequestVer11
implements OFBsnBwEnableGetRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnBwEnableGetRequestVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFBsnBwEnableGetRequestVer11 DEFAULT = new OFBsnBwEnableGetRequestVer11(0L);
    static final Reader READER = new Reader();
    static final OFBsnBwEnableGetRequestVer11Funnel FUNNEL = new OFBsnBwEnableGetRequestVer11Funnel();
    static final Writer WRITER = new Writer();

    OFBsnBwEnableGetRequestVer11(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 19L;
    }

    @Override
    public OFBsnBwEnableGetRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnBwEnableGetRequestVer11(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnBwEnableGetRequestVer11 other = (OFBsnBwEnableGetRequestVer11)obj;
        return this.xid == other.xid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnBwEnableGetRequestVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnBwEnableGetRequestVer11 message) {
            bb.writeByte(2);
            bb.writeByte(4);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(19);
        }
    }

    static class OFBsnBwEnableGetRequestVer11Funnel
    implements Funnel<OFBsnBwEnableGetRequestVer11> {
        private static final long serialVersionUID = 1L;

        OFBsnBwEnableGetRequestVer11Funnel() {
        }

        public void funnel(OFBsnBwEnableGetRequestVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)4);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(19);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnBwEnableGetRequest> {
        Reader() {
        }

        @Override
        public OFBsnBwEnableGetRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 19) {
                throw new OFParseError("Wrong subtype: Expected=0x13L(0x13L), got=" + subtype);
            }
            OFBsnBwEnableGetRequestVer11 bsnBwEnableGetRequestVer11 = new OFBsnBwEnableGetRequestVer11(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnBwEnableGetRequestVer11);
            }
            return bsnBwEnableGetRequestVer11;
        }
    }

    static class Builder
    implements OFBsnBwEnableGetRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwEnableGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 19L;
        }

        @Override
        public OFBsnBwEnableGetRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFBsnBwEnableGetRequestVer11(xid);
        }
    }

    static class BuilderWithParent
    implements OFBsnBwEnableGetRequest.Builder {
        final OFBsnBwEnableGetRequestVer11 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFBsnBwEnableGetRequestVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwEnableGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 19L;
        }

        @Override
        public OFBsnBwEnableGetRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFBsnBwEnableGetRequestVer11(xid);
        }
    }
}

