/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver11.OFBadActionErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBadInstructionErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBadMatchErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBadRequestErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFlowModFailedErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFGroupModFailedErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFHelloFailedErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFPortModFailedErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFQueueOpFailedErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFSwitchConfigFailedErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFTableModFailedErrorMsgVer11;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFErrorMsgVer11 {
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 10;
    public static final Reader READER = new Reader();

    OFErrorMsgVer11() {
    }

    static class Reader
    implements OFMessageReader<OFErrorMsg> {
        Reader() {
        }

        @Override
        public OFErrorMsg readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 10) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 10) {
                throw new OFParseError("Wrong length: Expected to be >= 10, was: " + length);
            }
            U32.f(bb.readInt());
            short errType = bb.readShort();
            bb.readerIndex(start);
            switch (errType) {
                case 2: {
                    return OFBadActionErrorMsgVer11.READER.readFrom(bb);
                }
                case 1: {
                    return OFBadRequestErrorMsgVer11.READER.readFrom(bb);
                }
                case 5: {
                    return OFFlowModFailedErrorMsgVer11.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloFailedErrorMsgVer11.READER.readFrom(bb);
                }
                case 7: {
                    return OFPortModFailedErrorMsgVer11.READER.readFrom(bb);
                }
                case 9: {
                    return OFQueueOpFailedErrorMsgVer11.READER.readFrom(bb);
                }
                case 3: {
                    return OFBadInstructionErrorMsgVer11.READER.readFrom(bb);
                }
                case 4: {
                    return OFBadMatchErrorMsgVer11.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupModFailedErrorMsgVer11.READER.readFrom(bb);
                }
                case 10: {
                    return OFSwitchConfigFailedErrorMsgVer11.READER.readFrom(bb);
                }
                case 8: {
                    return OFTableModFailedErrorMsgVer11.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator errType of class OFErrorMsgVer11: " + errType);
        }
    }
}

