/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsRequest;
import org.projectfloodlight.openflow.protocol.ver11.OFAggregateStatsRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFDescStatsRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFExperimenterStatsRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFlowStatsRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFGroupDescStatsRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFGroupStatsRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFPortStatsRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFQueueStatsRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFTableStatsRequestVer11;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsRequestVer11 {
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFStatsRequestVer11() {
    }

    static class Reader
    implements OFMessageReader<OFStatsRequest<?>> {
        Reader() {
        }

        @Override
        public OFStatsRequest<?> readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsRequestVer11.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsRequestVer11.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsRequestVer11.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsRequestVer11.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsRequestVer11.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsRequestVer11.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsRequestVer11.READER.readFrom(bb);
                }
                case 7: {
                    return OFGroupDescStatsRequestVer11.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupStatsRequestVer11.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsRequestVer11: " + statsType);
        }
    }
}

