/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionClearActions;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionClearActionsVer12
implements OFInstructionClearActions {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionClearActionsVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 8;
    static final OFInstructionClearActionsVer12 DEFAULT = new OFInstructionClearActionsVer12();
    static final OFInstructionClearActionsVer12 INSTANCE = new OFInstructionClearActionsVer12();
    static final Reader READER = new Reader();
    static final OFInstructionClearActionsVer12Funnel FUNNEL = new OFInstructionClearActionsVer12Funnel();
    static final Writer WRITER = new Writer();

    private OFInstructionClearActionsVer12() {
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.CLEAR_ACTIONS;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFInstructionClearActions.Builder createBuilder() {
        throw new UnsupportedOperationException("OFInstructionClearActionsVer12 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionClearActionsVer12(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionClearActionsVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFInstructionClearActionsVer12 message) {
            bb.writeShort(5);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFInstructionClearActionsVer12Funnel
    implements Funnel<OFInstructionClearActionsVer12> {
        private static final long serialVersionUID = 1L;

        OFInstructionClearActionsVer12Funnel() {
        }

        public void funnel(OFInstructionClearActionsVer12 message, PrimitiveSink sink) {
            sink.putShort((short)5);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionClearActions> {
        Reader() {
        }

        @Override
        public OFInstructionClearActions readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 5) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.CLEAR_ACTIONS(5), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

