/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpEcnMasked;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmIpEcnVer12;
import org.projectfloodlight.openflow.types.IpEcn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpEcnMaskedVer12
implements OFOxmIpEcnMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpEcnMaskedVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 6;
    private static final IpEcn DEFAULT_VALUE = IpEcn.NONE;
    private static final IpEcn DEFAULT_VALUE_MASK = IpEcn.NONE;
    private final IpEcn value;
    private final IpEcn mask;
    static final OFOxmIpEcnMaskedVer12 DEFAULT = new OFOxmIpEcnMaskedVer12(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIpEcnMaskedVer12Funnel FUNNEL = new OFOxmIpEcnMaskedVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpEcnMaskedVer12(IpEcn value, IpEcn mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpEcnMaskedVer12: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmIpEcnMaskedVer12: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147488514L;
    }

    @Override
    public IpEcn getValue() {
        return this.value;
    }

    @Override
    public IpEcn getMask() {
        return this.mask;
    }

    @Override
    public MatchField<IpEcn> getMatchField() {
        return MatchField.IP_ECN;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<IpEcn> getCanonical() {
        if (IpEcn.NO_MASK.equals(this.mask)) {
            return new OFOxmIpEcnVer12(this.value);
        }
        if (IpEcn.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmIpEcnMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpEcnMaskedVer12(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpEcnMaskedVer12 other = (OFOxmIpEcnMaskedVer12)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpEcnMaskedVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmIpEcnMaskedVer12 message) {
            bb.writeInt(-2147478782);
            message.value.writeByte(bb);
            message.mask.writeByte(bb);
        }
    }

    static class OFOxmIpEcnMaskedVer12Funnel
    implements Funnel<OFOxmIpEcnMaskedVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmIpEcnMaskedVer12Funnel() {
        }

        public void funnel(OFOxmIpEcnMaskedVer12 message, PrimitiveSink sink) {
            sink.putInt(-2147478782);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpEcnMasked> {
        Reader() {
        }

        @Override
        public OFOxmIpEcnMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147478782) {
                throw new OFParseError("Wrong typeLen: Expected=0x80001302L(0x80001302L), got=" + typeLen);
            }
            IpEcn value = IpEcn.readByte(bb);
            IpEcn mask = IpEcn.readByte(bb);
            OFOxmIpEcnMaskedVer12 oxmIpEcnMaskedVer12 = new OFOxmIpEcnMaskedVer12(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpEcnMaskedVer12);
            }
            return oxmIpEcnMaskedVer12;
        }
    }

    static class Builder
    implements OFOxmIpEcnMasked.Builder {
        private boolean valueSet;
        private IpEcn value;
        private boolean maskSet;
        private IpEcn mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147488514L;
        }

        @Override
        public IpEcn getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpEcnMasked.Builder setValue(IpEcn value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IpEcn getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpEcnMasked.Builder setMask(IpEcn mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IpEcn> getMatchField() {
            return MatchField.IP_ECN;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IpEcn> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmIpEcnMasked build() {
            IpEcn mask;
            IpEcn value;
            IpEcn ipEcn = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IpEcn ipEcn2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpEcnMaskedVer12(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpEcnMasked.Builder {
        final OFOxmIpEcnMaskedVer12 parentMessage;
        private boolean valueSet;
        private IpEcn value;
        private boolean maskSet;
        private IpEcn mask;

        BuilderWithParent(OFOxmIpEcnMaskedVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147488514L;
        }

        @Override
        public IpEcn getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpEcnMasked.Builder setValue(IpEcn value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IpEcn getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpEcnMasked.Builder setMask(IpEcn mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IpEcn> getMatchField() {
            return MatchField.IP_ECN;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IpEcn> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmIpEcnMasked build() {
            IpEcn mask;
            IpEcn value;
            IpEcn ipEcn = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IpEcn ipEcn2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpEcnMaskedVer12(value, mask);
        }
    }
}

