/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunGpeFlags;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTunGpeFlagsVer12
implements OFOxmTunGpeFlags {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTunGpeFlagsVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmTunGpeFlagsVer12 DEFAULT = new OFOxmTunGpeFlagsVer12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmTunGpeFlagsVer12Funnel FUNNEL = new OFOxmTunGpeFlagsVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTunGpeFlagsVer12(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmTunGpeFlagsVer12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 122881L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.TUN_GPE_FLAGS;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmTunGpeFlags.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTunGpeFlagsVer12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTunGpeFlagsVer12 other = (OFOxmTunGpeFlagsVer12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTunGpeFlagsVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmTunGpeFlagsVer12 message) {
            bb.writeInt(122881);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmTunGpeFlagsVer12Funnel
    implements Funnel<OFOxmTunGpeFlagsVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmTunGpeFlagsVer12Funnel() {
        }

        public void funnel(OFOxmTunGpeFlagsVer12 message, PrimitiveSink sink) {
            sink.putInt(122881);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTunGpeFlags> {
        Reader() {
        }

        @Override
        public OFOxmTunGpeFlags readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 122881) {
                throw new OFParseError("Wrong typeLen: Expected=0x1e001L(0x1e001L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmTunGpeFlagsVer12 oxmTunGpeFlagsVer12 = new OFOxmTunGpeFlagsVer12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTunGpeFlagsVer12);
            }
            return oxmTunGpeFlagsVer12;
        }
    }

    static class Builder
    implements OFOxmTunGpeFlags.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 122881L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunGpeFlags.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.TUN_GPE_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmTunGpeFlags build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunGpeFlagsVer12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmTunGpeFlags.Builder {
        final OFOxmTunGpeFlagsVer12 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmTunGpeFlagsVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 122881L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunGpeFlags.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.TUN_GPE_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmTunGpeFlags build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunGpeFlagsVer12(value);
        }
    }
}

