/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.action.OFActionExperimenter;
import org.projectfloodlight.openflow.protocol.ver13.OFActionBsnVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFActionCircuitVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFActionNiciraVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFActionOplinkAttVer13;
import org.projectfloodlight.openflow.types.U16;

abstract class OFActionExperimenterVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFActionExperimenterVer13() {
    }

    static class Reader
    implements OFMessageReader<OFActionExperimenter> {
        Reader() {
        }

        @Override
        public OFActionExperimenter readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            int experimenter = bb.readInt();
            bb.readerIndex(start);
            switch (experimenter) {
                case 6035143: {
                    return OFActionBsnVer13.READER.readFrom(bb);
                }
                case 8992: {
                    return OFActionNiciraVer13.READER.readFrom(bb);
                }
                case 7636849: {
                    return OFActionCircuitVer13.READER.readFrom(bb);
                }
                case -16777080: {
                    return OFActionOplinkAttVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator experimenter of class OFActionExperimenterVer13: " + experimenter);
        }
    }
}

