/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPortCounterStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnPortCounterStatsEntryVer13
implements OFBsnPortCounterStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnPortCounterStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 8;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final List<U64> DEFAULT_VALUES = ImmutableList.of();
    private final OFPort portNo;
    private final List<U64> values;
    static final OFBsnPortCounterStatsEntryVer13 DEFAULT = new OFBsnPortCounterStatsEntryVer13(DEFAULT_PORT_NO, DEFAULT_VALUES);
    static final Reader READER = new Reader();
    static final OFBsnPortCounterStatsEntryVer13Funnel FUNNEL = new OFBsnPortCounterStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnPortCounterStatsEntryVer13(OFPort portNo, List<U64> values) {
        if (portNo == null) {
            throw new NullPointerException("OFBsnPortCounterStatsEntryVer13: property portNo cannot be null");
        }
        if (values == null) {
            throw new NullPointerException("OFBsnPortCounterStatsEntryVer13: property values cannot be null");
        }
        this.portNo = portNo;
        this.values = values;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public List<U64> getValues() {
        return this.values;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnPortCounterStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnPortCounterStatsEntryVer13(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("values=").append(this.values);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPortCounterStatsEntryVer13 other = (OFBsnPortCounterStatsEntryVer13)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnPortCounterStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnPortCounterStatsEntryVer13 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            message.portNo.write4Bytes(bb);
            ChannelUtils.writeList(bb, message.values);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnPortCounterStatsEntryVer13Funnel
    implements Funnel<OFBsnPortCounterStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnPortCounterStatsEntryVer13Funnel() {
        }

        public void funnel(OFBsnPortCounterStatsEntryVer13 message, PrimitiveSink sink) {
            message.portNo.putTo(sink);
            FunnelUtils.putList(message.values, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnPortCounterStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnPortCounterStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            OFPort portNo = OFPort.read4Bytes(bb);
            List<U64> values = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U64.READER);
            OFBsnPortCounterStatsEntryVer13 bsnPortCounterStatsEntryVer13 = new OFBsnPortCounterStatsEntryVer13(portNo, values);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnPortCounterStatsEntryVer13);
            }
            return bsnPortCounterStatsEntryVer13;
        }
    }

    static class Builder
    implements OFBsnPortCounterStatsEntry.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean valuesSet;
        private List<U64> values;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPortCounterStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public List<U64> getValues() {
            return this.values;
        }

        @Override
        public OFBsnPortCounterStatsEntry.Builder setValues(List<U64> values) {
            this.values = values;
            this.valuesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnPortCounterStatsEntry build() {
            List<U64> values;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            List<U64> list = values = this.valuesSet ? this.values : DEFAULT_VALUES;
            if (values == null) {
                throw new NullPointerException("Property values must not be null");
            }
            return new OFBsnPortCounterStatsEntryVer13(portNo, values);
        }
    }

    static class BuilderWithParent
    implements OFBsnPortCounterStatsEntry.Builder {
        final OFBsnPortCounterStatsEntryVer13 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean valuesSet;
        private List<U64> values;

        BuilderWithParent(OFBsnPortCounterStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPortCounterStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public List<U64> getValues() {
            return this.values;
        }

        @Override
        public OFBsnPortCounterStatsEntry.Builder setValues(List<U64> values) {
            this.values = values;
            this.valuesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnPortCounterStatsEntry build() {
            List values;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            List list = values = this.valuesSet ? this.values : this.parentMessage.values;
            if (values == null) {
                throw new NullPointerException("Property values must not be null");
            }
            return new OFBsnPortCounterStatsEntryVer13(portNo, values);
        }
    }
}

