/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvCircuitId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvCircuitIdVer13
implements OFBsnTlvCircuitId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvCircuitIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    private static final byte[] DEFAULT_VALUE = new byte[0];
    private final byte[] value;
    static final OFBsnTlvCircuitIdVer13 DEFAULT = new OFBsnTlvCircuitIdVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvCircuitIdVer13Funnel FUNNEL = new OFBsnTlvCircuitIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvCircuitIdVer13(byte[] value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvCircuitIdVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvCircuitId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvCircuitIdVer13(");
        b.append("value=").append(Arrays.toString(this.value));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvCircuitIdVer13 other = (OFBsnTlvCircuitIdVer13)obj;
        return Arrays.equals(this.value, other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvCircuitIdVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvCircuitIdVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(14);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeBytes(message.value);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvCircuitIdVer13Funnel
    implements Funnel<OFBsnTlvCircuitIdVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvCircuitIdVer13Funnel() {
        }

        public void funnel(OFBsnTlvCircuitIdVer13 message, PrimitiveSink sink) {
            sink.putShort((short)14);
            sink.putBytes(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvCircuitId> {
        Reader() {
        }

        @Override
        public OFBsnTlvCircuitId readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 14) {
                throw new OFParseError("Wrong type: Expected=0xe(0xe), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            byte[] value = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnTlvCircuitIdVer13 bsnTlvCircuitIdVer13 = new OFBsnTlvCircuitIdVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvCircuitIdVer13);
            }
            return bsnTlvCircuitIdVer13;
        }
    }

    static class Builder
    implements OFBsnTlvCircuitId.Builder {
        private boolean valueSet;
        private byte[] value;

        Builder() {
        }

        @Override
        public int getType() {
            return 14;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvCircuitId.Builder setValue(byte[] value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvCircuitId build() {
            byte[] value;
            byte[] byArray = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvCircuitIdVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvCircuitId.Builder {
        final OFBsnTlvCircuitIdVer13 parentMessage;
        private boolean valueSet;
        private byte[] value;

        BuilderWithParent(OFBsnTlvCircuitIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 14;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvCircuitId.Builder setValue(byte[] value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvCircuitId build() {
            byte[] value;
            byte[] byArray = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvCircuitIdVer13(value);
        }
    }
}

