/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFCalientOcsAlarm;
import org.projectfloodlight.openflow.protocol.OFCalientOpticalPortAdminState;
import org.projectfloodlight.openflow.protocol.OFCalientOpticalPortOperCapability;
import org.projectfloodlight.openflow.protocol.OFCalientOpticalPortOperState;
import org.projectfloodlight.openflow.protocol.OFCalientPortStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientOcsAlarmSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientOpticalPortAdminStateSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientOpticalPortOperCapabilitySerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientOpticalPortOperStateSerializerVer13;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFCalientPortStatsEntryVer13
implements OFCalientPortStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientPortStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 104;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final Set<OFCalientOpticalPortAdminState> DEFAULT_IN_ADMIN_STATUS = ImmutableSet.of();
    private static final Set<OFCalientOpticalPortOperState> DEFAULT_IN_OPER_STATUS = ImmutableSet.of();
    private static final Set<OFCalientOpticalPortOperCapability> DEFAULT_IN_OPER_CAPABILITY = ImmutableSet.of();
    private static final Set<OFCalientOcsAlarm> DEFAULT_IN_ALARM = ImmutableSet.of();
    private static final String DEFAULT_INPORT_POWER = "";
    private static final String DEFAULT_OUTPORT_POWER = "";
    private static final Set<OFCalientOpticalPortAdminState> DEFAULT_OUT_ADMIN_STATUS = ImmutableSet.of();
    private static final Set<OFCalientOpticalPortOperState> DEFAULT_OUT_OPER_STATUS = ImmutableSet.of();
    private static final Set<OFCalientOpticalPortOperCapability> DEFAULT_OUT_OPER_CAPABILITY = ImmutableSet.of();
    private static final Set<OFCalientOcsAlarm> DEFAULT_OUT_ALARM = ImmutableSet.of();
    private static final String DEFAULT_IN_CIRCUIT_ID = "";
    private static final String DEFAULT_OUT_CIRCUIT_ID = "";
    private final OFPort portNo;
    private final Set<OFCalientOpticalPortAdminState> inAdminStatus;
    private final Set<OFCalientOpticalPortOperState> inOperStatus;
    private final Set<OFCalientOpticalPortOperCapability> inOperCapability;
    private final Set<OFCalientOcsAlarm> inAlarm;
    private final String inportPower;
    private final String outportPower;
    private final Set<OFCalientOpticalPortAdminState> outAdminStatus;
    private final Set<OFCalientOpticalPortOperState> outOperStatus;
    private final Set<OFCalientOpticalPortOperCapability> outOperCapability;
    private final Set<OFCalientOcsAlarm> outAlarm;
    private final String inCircuitId;
    private final String outCircuitId;
    static final OFCalientPortStatsEntryVer13 DEFAULT = new OFCalientPortStatsEntryVer13(DEFAULT_PORT_NO, DEFAULT_IN_ADMIN_STATUS, DEFAULT_IN_OPER_STATUS, DEFAULT_IN_OPER_CAPABILITY, DEFAULT_IN_ALARM, "", "", DEFAULT_OUT_ADMIN_STATUS, DEFAULT_OUT_OPER_STATUS, DEFAULT_OUT_OPER_CAPABILITY, DEFAULT_OUT_ALARM, "", "");
    static final Reader READER = new Reader();
    static final OFCalientPortStatsEntryVer13Funnel FUNNEL = new OFCalientPortStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFCalientPortStatsEntryVer13(OFPort portNo, Set<OFCalientOpticalPortAdminState> inAdminStatus, Set<OFCalientOpticalPortOperState> inOperStatus, Set<OFCalientOpticalPortOperCapability> inOperCapability, Set<OFCalientOcsAlarm> inAlarm, String inportPower, String outportPower, Set<OFCalientOpticalPortAdminState> outAdminStatus, Set<OFCalientOpticalPortOperState> outOperStatus, Set<OFCalientOpticalPortOperCapability> outOperCapability, Set<OFCalientOcsAlarm> outAlarm, String inCircuitId, String outCircuitId) {
        if (portNo == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property portNo cannot be null");
        }
        if (inAdminStatus == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inAdminStatus cannot be null");
        }
        if (inOperStatus == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inOperStatus cannot be null");
        }
        if (inOperCapability == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inOperCapability cannot be null");
        }
        if (inAlarm == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inAlarm cannot be null");
        }
        if (inportPower == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inportPower cannot be null");
        }
        if (outportPower == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outportPower cannot be null");
        }
        if (outAdminStatus == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outAdminStatus cannot be null");
        }
        if (outOperStatus == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outOperStatus cannot be null");
        }
        if (outOperCapability == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outOperCapability cannot be null");
        }
        if (outAlarm == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outAlarm cannot be null");
        }
        if (inCircuitId == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inCircuitId cannot be null");
        }
        if (outCircuitId == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outCircuitId cannot be null");
        }
        this.portNo = portNo;
        this.inAdminStatus = inAdminStatus;
        this.inOperStatus = inOperStatus;
        this.inOperCapability = inOperCapability;
        this.inAlarm = inAlarm;
        this.inportPower = inportPower;
        this.outportPower = outportPower;
        this.outAdminStatus = outAdminStatus;
        this.outOperStatus = outOperStatus;
        this.outOperCapability = outOperCapability;
        this.outAlarm = outAlarm;
        this.inCircuitId = inCircuitId;
        this.outCircuitId = outCircuitId;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public Set<OFCalientOpticalPortAdminState> getInAdminStatus() {
        return this.inAdminStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperState> getInOperStatus() {
        return this.inOperStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperCapability> getInOperCapability() {
        return this.inOperCapability;
    }

    @Override
    public Set<OFCalientOcsAlarm> getInAlarm() {
        return this.inAlarm;
    }

    @Override
    public String getInportPower() {
        return this.inportPower;
    }

    @Override
    public String getOutportPower() {
        return this.outportPower;
    }

    @Override
    public Set<OFCalientOpticalPortAdminState> getOutAdminStatus() {
        return this.outAdminStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperState> getOutOperStatus() {
        return this.outOperStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperCapability> getOutOperCapability() {
        return this.outOperCapability;
    }

    @Override
    public Set<OFCalientOcsAlarm> getOutAlarm() {
        return this.outAlarm;
    }

    @Override
    public String getInCircuitId() {
        return this.inCircuitId;
    }

    @Override
    public String getOutCircuitId() {
        return this.outCircuitId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFCalientPortStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientPortStatsEntryVer13(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("inAdminStatus=").append(this.inAdminStatus);
        b.append(", ");
        b.append("inOperStatus=").append(this.inOperStatus);
        b.append(", ");
        b.append("inOperCapability=").append(this.inOperCapability);
        b.append(", ");
        b.append("inAlarm=").append(this.inAlarm);
        b.append(", ");
        b.append("inportPower=").append(this.inportPower);
        b.append(", ");
        b.append("outportPower=").append(this.outportPower);
        b.append(", ");
        b.append("outAdminStatus=").append(this.outAdminStatus);
        b.append(", ");
        b.append("outOperStatus=").append(this.outOperStatus);
        b.append(", ");
        b.append("outOperCapability=").append(this.outOperCapability);
        b.append(", ");
        b.append("outAlarm=").append(this.outAlarm);
        b.append(", ");
        b.append("inCircuitId=").append(this.inCircuitId);
        b.append(", ");
        b.append("outCircuitId=").append(this.outCircuitId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFCalientPortStatsEntryVer13 other = (OFCalientPortStatsEntryVer13)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.inAdminStatus == null ? other.inAdminStatus != null : !this.inAdminStatus.equals(other.inAdminStatus)) {
            return false;
        }
        if (this.inOperStatus == null ? other.inOperStatus != null : !this.inOperStatus.equals(other.inOperStatus)) {
            return false;
        }
        if (this.inOperCapability == null ? other.inOperCapability != null : !this.inOperCapability.equals(other.inOperCapability)) {
            return false;
        }
        if (this.inAlarm == null ? other.inAlarm != null : !this.inAlarm.equals(other.inAlarm)) {
            return false;
        }
        if (this.inportPower == null ? other.inportPower != null : !this.inportPower.equals(other.inportPower)) {
            return false;
        }
        if (this.outportPower == null ? other.outportPower != null : !this.outportPower.equals(other.outportPower)) {
            return false;
        }
        if (this.outAdminStatus == null ? other.outAdminStatus != null : !this.outAdminStatus.equals(other.outAdminStatus)) {
            return false;
        }
        if (this.outOperStatus == null ? other.outOperStatus != null : !this.outOperStatus.equals(other.outOperStatus)) {
            return false;
        }
        if (this.outOperCapability == null ? other.outOperCapability != null : !this.outOperCapability.equals(other.outOperCapability)) {
            return false;
        }
        if (this.outAlarm == null ? other.outAlarm != null : !this.outAlarm.equals(other.outAlarm)) {
            return false;
        }
        if (this.inCircuitId == null ? other.inCircuitId != null : !this.inCircuitId.equals(other.inCircuitId)) {
            return false;
        }
        return !(this.outCircuitId == null ? other.outCircuitId != null : !this.outCircuitId.equals(other.outCircuitId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.inAdminStatus == null ? 0 : this.inAdminStatus.hashCode());
        result = 31 * result + (this.inOperStatus == null ? 0 : this.inOperStatus.hashCode());
        result = 31 * result + (this.inOperCapability == null ? 0 : this.inOperCapability.hashCode());
        result = 31 * result + (this.inAlarm == null ? 0 : this.inAlarm.hashCode());
        result = 31 * result + (this.inportPower == null ? 0 : this.inportPower.hashCode());
        result = 31 * result + (this.outportPower == null ? 0 : this.outportPower.hashCode());
        result = 31 * result + (this.outAdminStatus == null ? 0 : this.outAdminStatus.hashCode());
        result = 31 * result + (this.outOperStatus == null ? 0 : this.outOperStatus.hashCode());
        result = 31 * result + (this.outOperCapability == null ? 0 : this.outOperCapability.hashCode());
        result = 31 * result + (this.outAlarm == null ? 0 : this.outAlarm.hashCode());
        result = 31 * result + (this.inCircuitId == null ? 0 : this.inCircuitId.hashCode());
        result = 31 * result + (this.outCircuitId == null ? 0 : this.outCircuitId.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFCalientPortStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFCalientPortStatsEntryVer13 message) {
            bb.writeShort(104);
            bb.writeZero(2);
            message.portNo.write4Bytes(bb);
            OFCalientOpticalPortAdminStateSerializerVer13.writeTo(bb, message.inAdminStatus);
            OFCalientOpticalPortOperStateSerializerVer13.writeTo(bb, message.inOperStatus);
            OFCalientOpticalPortOperCapabilitySerializerVer13.writeTo(bb, message.inOperCapability);
            OFCalientOcsAlarmSerializerVer13.writeTo(bb, message.inAlarm);
            bb.writeZero(4);
            ChannelUtils.writeFixedLengthString(bb, message.inportPower, 6);
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.outportPower, 6);
            bb.writeZero(2);
            OFCalientOpticalPortAdminStateSerializerVer13.writeTo(bb, message.outAdminStatus);
            OFCalientOpticalPortOperStateSerializerVer13.writeTo(bb, message.outOperStatus);
            OFCalientOpticalPortOperCapabilitySerializerVer13.writeTo(bb, message.outOperCapability);
            OFCalientOcsAlarmSerializerVer13.writeTo(bb, message.outAlarm);
            bb.writeZero(4);
            ChannelUtils.writeFixedLengthString(bb, message.inCircuitId, 32);
            ChannelUtils.writeFixedLengthString(bb, message.outCircuitId, 32);
        }
    }

    static class OFCalientPortStatsEntryVer13Funnel
    implements Funnel<OFCalientPortStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFCalientPortStatsEntryVer13Funnel() {
        }

        public void funnel(OFCalientPortStatsEntryVer13 message, PrimitiveSink sink) {
            sink.putShort((short)104);
            message.portNo.putTo(sink);
            OFCalientOpticalPortAdminStateSerializerVer13.putTo(message.inAdminStatus, sink);
            OFCalientOpticalPortOperStateSerializerVer13.putTo(message.inOperStatus, sink);
            OFCalientOpticalPortOperCapabilitySerializerVer13.putTo(message.inOperCapability, sink);
            OFCalientOcsAlarmSerializerVer13.putTo(message.inAlarm, sink);
            sink.putUnencodedChars((CharSequence)message.inportPower);
            sink.putUnencodedChars((CharSequence)message.outportPower);
            OFCalientOpticalPortAdminStateSerializerVer13.putTo(message.outAdminStatus, sink);
            OFCalientOpticalPortOperStateSerializerVer13.putTo(message.outOperStatus, sink);
            OFCalientOpticalPortOperCapabilitySerializerVer13.putTo(message.outOperCapability, sink);
            OFCalientOcsAlarmSerializerVer13.putTo(message.outAlarm, sink);
            sink.putUnencodedChars((CharSequence)message.inCircuitId);
            sink.putUnencodedChars((CharSequence)message.outCircuitId);
        }
    }

    static class Reader
    implements OFMessageReader<OFCalientPortStatsEntry> {
        Reader() {
        }

        @Override
        public OFCalientPortStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length != 104) {
                throw new OFParseError("Wrong length: Expected=104(104), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            OFPort portNo = OFPort.read4Bytes(bb);
            Set<OFCalientOpticalPortAdminState> inAdminStatus = OFCalientOpticalPortAdminStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperState> inOperStatus = OFCalientOpticalPortOperStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperCapability> inOperCapability = OFCalientOpticalPortOperCapabilitySerializerVer13.readFrom(bb);
            Set<OFCalientOcsAlarm> inAlarm = OFCalientOcsAlarmSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            String inportPower = ChannelUtils.readFixedLengthString(bb, 6);
            bb.skipBytes(2);
            String outportPower = ChannelUtils.readFixedLengthString(bb, 6);
            bb.skipBytes(2);
            Set<OFCalientOpticalPortAdminState> outAdminStatus = OFCalientOpticalPortAdminStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperState> outOperStatus = OFCalientOpticalPortOperStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperCapability> outOperCapability = OFCalientOpticalPortOperCapabilitySerializerVer13.readFrom(bb);
            Set<OFCalientOcsAlarm> outAlarm = OFCalientOcsAlarmSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            String inCircuitId = ChannelUtils.readFixedLengthString(bb, 32);
            String outCircuitId = ChannelUtils.readFixedLengthString(bb, 32);
            OFCalientPortStatsEntryVer13 calientPortStatsEntryVer13 = new OFCalientPortStatsEntryVer13(portNo, inAdminStatus, inOperStatus, inOperCapability, inAlarm, inportPower, outportPower, outAdminStatus, outOperStatus, outOperCapability, outAlarm, inCircuitId, outCircuitId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)calientPortStatsEntryVer13);
            }
            return calientPortStatsEntryVer13;
        }
    }

    static class Builder
    implements OFCalientPortStatsEntry.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean inAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> inAdminStatus;
        private boolean inOperStatusSet;
        private Set<OFCalientOpticalPortOperState> inOperStatus;
        private boolean inOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> inOperCapability;
        private boolean inAlarmSet;
        private Set<OFCalientOcsAlarm> inAlarm;
        private boolean inportPowerSet;
        private String inportPower;
        private boolean outportPowerSet;
        private String outportPower;
        private boolean outAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> outAdminStatus;
        private boolean outOperStatusSet;
        private Set<OFCalientOpticalPortOperState> outOperStatus;
        private boolean outOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> outOperCapability;
        private boolean outAlarmSet;
        private Set<OFCalientOcsAlarm> outAlarm;
        private boolean inCircuitIdSet;
        private String inCircuitId;
        private boolean outCircuitIdSet;
        private String outCircuitId;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortAdminState> getInAdminStatus() {
            return this.inAdminStatus;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInAdminStatus(Set<OFCalientOpticalPortAdminState> inAdminStatus) {
            this.inAdminStatus = inAdminStatus;
            this.inAdminStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortOperState> getInOperStatus() {
            return this.inOperStatus;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInOperStatus(Set<OFCalientOpticalPortOperState> inOperStatus) {
            this.inOperStatus = inOperStatus;
            this.inOperStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortOperCapability> getInOperCapability() {
            return this.inOperCapability;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInOperCapability(Set<OFCalientOpticalPortOperCapability> inOperCapability) {
            this.inOperCapability = inOperCapability;
            this.inOperCapabilitySet = true;
            return this;
        }

        @Override
        public Set<OFCalientOcsAlarm> getInAlarm() {
            return this.inAlarm;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInAlarm(Set<OFCalientOcsAlarm> inAlarm) {
            this.inAlarm = inAlarm;
            this.inAlarmSet = true;
            return this;
        }

        @Override
        public String getInportPower() {
            return this.inportPower;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInportPower(String inportPower) {
            this.inportPower = inportPower;
            this.inportPowerSet = true;
            return this;
        }

        @Override
        public String getOutportPower() {
            return this.outportPower;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutportPower(String outportPower) {
            this.outportPower = outportPower;
            this.outportPowerSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortAdminState> getOutAdminStatus() {
            return this.outAdminStatus;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutAdminStatus(Set<OFCalientOpticalPortAdminState> outAdminStatus) {
            this.outAdminStatus = outAdminStatus;
            this.outAdminStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortOperState> getOutOperStatus() {
            return this.outOperStatus;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutOperStatus(Set<OFCalientOpticalPortOperState> outOperStatus) {
            this.outOperStatus = outOperStatus;
            this.outOperStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortOperCapability> getOutOperCapability() {
            return this.outOperCapability;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutOperCapability(Set<OFCalientOpticalPortOperCapability> outOperCapability) {
            this.outOperCapability = outOperCapability;
            this.outOperCapabilitySet = true;
            return this;
        }

        @Override
        public Set<OFCalientOcsAlarm> getOutAlarm() {
            return this.outAlarm;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutAlarm(Set<OFCalientOcsAlarm> outAlarm) {
            this.outAlarm = outAlarm;
            this.outAlarmSet = true;
            return this;
        }

        @Override
        public String getInCircuitId() {
            return this.inCircuitId;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInCircuitId(String inCircuitId) {
            this.inCircuitId = inCircuitId;
            this.inCircuitIdSet = true;
            return this;
        }

        @Override
        public String getOutCircuitId() {
            return this.outCircuitId;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutCircuitId(String outCircuitId) {
            this.outCircuitId = outCircuitId;
            this.outCircuitIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFCalientPortStatsEntry build() {
            String outCircuitId;
            String inCircuitId;
            Set<OFCalientOcsAlarm> outAlarm;
            Set<OFCalientOpticalPortOperCapability> outOperCapability;
            Set<OFCalientOpticalPortOperState> outOperStatus;
            Set<OFCalientOpticalPortAdminState> outAdminStatus;
            String outportPower;
            String inportPower;
            Set<OFCalientOcsAlarm> inAlarm;
            Set<OFCalientOpticalPortOperCapability> inOperCapability;
            Set<OFCalientOpticalPortOperState> inOperStatus;
            Set<OFCalientOpticalPortAdminState> inAdminStatus;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            Set<OFCalientOpticalPortAdminState> set = inAdminStatus = this.inAdminStatusSet ? this.inAdminStatus : DEFAULT_IN_ADMIN_STATUS;
            if (inAdminStatus == null) {
                throw new NullPointerException("Property inAdminStatus must not be null");
            }
            Set<OFCalientOpticalPortOperState> set2 = inOperStatus = this.inOperStatusSet ? this.inOperStatus : DEFAULT_IN_OPER_STATUS;
            if (inOperStatus == null) {
                throw new NullPointerException("Property inOperStatus must not be null");
            }
            Set<OFCalientOpticalPortOperCapability> set3 = inOperCapability = this.inOperCapabilitySet ? this.inOperCapability : DEFAULT_IN_OPER_CAPABILITY;
            if (inOperCapability == null) {
                throw new NullPointerException("Property inOperCapability must not be null");
            }
            Set<OFCalientOcsAlarm> set4 = inAlarm = this.inAlarmSet ? this.inAlarm : DEFAULT_IN_ALARM;
            if (inAlarm == null) {
                throw new NullPointerException("Property inAlarm must not be null");
            }
            String string = inportPower = this.inportPowerSet ? this.inportPower : "";
            if (inportPower == null) {
                throw new NullPointerException("Property inportPower must not be null");
            }
            String string2 = outportPower = this.outportPowerSet ? this.outportPower : "";
            if (outportPower == null) {
                throw new NullPointerException("Property outportPower must not be null");
            }
            Set<OFCalientOpticalPortAdminState> set5 = outAdminStatus = this.outAdminStatusSet ? this.outAdminStatus : DEFAULT_OUT_ADMIN_STATUS;
            if (outAdminStatus == null) {
                throw new NullPointerException("Property outAdminStatus must not be null");
            }
            Set<OFCalientOpticalPortOperState> set6 = outOperStatus = this.outOperStatusSet ? this.outOperStatus : DEFAULT_OUT_OPER_STATUS;
            if (outOperStatus == null) {
                throw new NullPointerException("Property outOperStatus must not be null");
            }
            Set<OFCalientOpticalPortOperCapability> set7 = outOperCapability = this.outOperCapabilitySet ? this.outOperCapability : DEFAULT_OUT_OPER_CAPABILITY;
            if (outOperCapability == null) {
                throw new NullPointerException("Property outOperCapability must not be null");
            }
            Set<OFCalientOcsAlarm> set8 = outAlarm = this.outAlarmSet ? this.outAlarm : DEFAULT_OUT_ALARM;
            if (outAlarm == null) {
                throw new NullPointerException("Property outAlarm must not be null");
            }
            String string3 = inCircuitId = this.inCircuitIdSet ? this.inCircuitId : "";
            if (inCircuitId == null) {
                throw new NullPointerException("Property inCircuitId must not be null");
            }
            String string4 = outCircuitId = this.outCircuitIdSet ? this.outCircuitId : "";
            if (outCircuitId == null) {
                throw new NullPointerException("Property outCircuitId must not be null");
            }
            return new OFCalientPortStatsEntryVer13(portNo, inAdminStatus, inOperStatus, inOperCapability, inAlarm, inportPower, outportPower, outAdminStatus, outOperStatus, outOperCapability, outAlarm, inCircuitId, outCircuitId);
        }
    }

    static class BuilderWithParent
    implements OFCalientPortStatsEntry.Builder {
        final OFCalientPortStatsEntryVer13 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean inAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> inAdminStatus;
        private boolean inOperStatusSet;
        private Set<OFCalientOpticalPortOperState> inOperStatus;
        private boolean inOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> inOperCapability;
        private boolean inAlarmSet;
        private Set<OFCalientOcsAlarm> inAlarm;
        private boolean inportPowerSet;
        private String inportPower;
        private boolean outportPowerSet;
        private String outportPower;
        private boolean outAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> outAdminStatus;
        private boolean outOperStatusSet;
        private Set<OFCalientOpticalPortOperState> outOperStatus;
        private boolean outOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> outOperCapability;
        private boolean outAlarmSet;
        private Set<OFCalientOcsAlarm> outAlarm;
        private boolean inCircuitIdSet;
        private String inCircuitId;
        private boolean outCircuitIdSet;
        private String outCircuitId;

        BuilderWithParent(OFCalientPortStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortAdminState> getInAdminStatus() {
            return this.inAdminStatus;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInAdminStatus(Set<OFCalientOpticalPortAdminState> inAdminStatus) {
            this.inAdminStatus = inAdminStatus;
            this.inAdminStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortOperState> getInOperStatus() {
            return this.inOperStatus;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInOperStatus(Set<OFCalientOpticalPortOperState> inOperStatus) {
            this.inOperStatus = inOperStatus;
            this.inOperStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortOperCapability> getInOperCapability() {
            return this.inOperCapability;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInOperCapability(Set<OFCalientOpticalPortOperCapability> inOperCapability) {
            this.inOperCapability = inOperCapability;
            this.inOperCapabilitySet = true;
            return this;
        }

        @Override
        public Set<OFCalientOcsAlarm> getInAlarm() {
            return this.inAlarm;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInAlarm(Set<OFCalientOcsAlarm> inAlarm) {
            this.inAlarm = inAlarm;
            this.inAlarmSet = true;
            return this;
        }

        @Override
        public String getInportPower() {
            return this.inportPower;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInportPower(String inportPower) {
            this.inportPower = inportPower;
            this.inportPowerSet = true;
            return this;
        }

        @Override
        public String getOutportPower() {
            return this.outportPower;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutportPower(String outportPower) {
            this.outportPower = outportPower;
            this.outportPowerSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortAdminState> getOutAdminStatus() {
            return this.outAdminStatus;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutAdminStatus(Set<OFCalientOpticalPortAdminState> outAdminStatus) {
            this.outAdminStatus = outAdminStatus;
            this.outAdminStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortOperState> getOutOperStatus() {
            return this.outOperStatus;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutOperStatus(Set<OFCalientOpticalPortOperState> outOperStatus) {
            this.outOperStatus = outOperStatus;
            this.outOperStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientOpticalPortOperCapability> getOutOperCapability() {
            return this.outOperCapability;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutOperCapability(Set<OFCalientOpticalPortOperCapability> outOperCapability) {
            this.outOperCapability = outOperCapability;
            this.outOperCapabilitySet = true;
            return this;
        }

        @Override
        public Set<OFCalientOcsAlarm> getOutAlarm() {
            return this.outAlarm;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutAlarm(Set<OFCalientOcsAlarm> outAlarm) {
            this.outAlarm = outAlarm;
            this.outAlarmSet = true;
            return this;
        }

        @Override
        public String getInCircuitId() {
            return this.inCircuitId;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setInCircuitId(String inCircuitId) {
            this.inCircuitId = inCircuitId;
            this.inCircuitIdSet = true;
            return this;
        }

        @Override
        public String getOutCircuitId() {
            return this.outCircuitId;
        }

        @Override
        public OFCalientPortStatsEntry.Builder setOutCircuitId(String outCircuitId) {
            this.outCircuitId = outCircuitId;
            this.outCircuitIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFCalientPortStatsEntry build() {
            String outCircuitId;
            String inCircuitId;
            Set outAlarm;
            Set outOperCapability;
            Set outOperStatus;
            Set outAdminStatus;
            String outportPower;
            String inportPower;
            Set inAlarm;
            Set inOperCapability;
            Set inOperStatus;
            Set inAdminStatus;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            Set set = inAdminStatus = this.inAdminStatusSet ? this.inAdminStatus : this.parentMessage.inAdminStatus;
            if (inAdminStatus == null) {
                throw new NullPointerException("Property inAdminStatus must not be null");
            }
            Set set2 = inOperStatus = this.inOperStatusSet ? this.inOperStatus : this.parentMessage.inOperStatus;
            if (inOperStatus == null) {
                throw new NullPointerException("Property inOperStatus must not be null");
            }
            Set set3 = inOperCapability = this.inOperCapabilitySet ? this.inOperCapability : this.parentMessage.inOperCapability;
            if (inOperCapability == null) {
                throw new NullPointerException("Property inOperCapability must not be null");
            }
            Set set4 = inAlarm = this.inAlarmSet ? this.inAlarm : this.parentMessage.inAlarm;
            if (inAlarm == null) {
                throw new NullPointerException("Property inAlarm must not be null");
            }
            String string = inportPower = this.inportPowerSet ? this.inportPower : this.parentMessage.inportPower;
            if (inportPower == null) {
                throw new NullPointerException("Property inportPower must not be null");
            }
            String string2 = outportPower = this.outportPowerSet ? this.outportPower : this.parentMessage.outportPower;
            if (outportPower == null) {
                throw new NullPointerException("Property outportPower must not be null");
            }
            Set set5 = outAdminStatus = this.outAdminStatusSet ? this.outAdminStatus : this.parentMessage.outAdminStatus;
            if (outAdminStatus == null) {
                throw new NullPointerException("Property outAdminStatus must not be null");
            }
            Set set6 = outOperStatus = this.outOperStatusSet ? this.outOperStatus : this.parentMessage.outOperStatus;
            if (outOperStatus == null) {
                throw new NullPointerException("Property outOperStatus must not be null");
            }
            Set set7 = outOperCapability = this.outOperCapabilitySet ? this.outOperCapability : this.parentMessage.outOperCapability;
            if (outOperCapability == null) {
                throw new NullPointerException("Property outOperCapability must not be null");
            }
            Set set8 = outAlarm = this.outAlarmSet ? this.outAlarm : this.parentMessage.outAlarm;
            if (outAlarm == null) {
                throw new NullPointerException("Property outAlarm must not be null");
            }
            String string3 = inCircuitId = this.inCircuitIdSet ? this.inCircuitId : this.parentMessage.inCircuitId;
            if (inCircuitId == null) {
                throw new NullPointerException("Property inCircuitId must not be null");
            }
            String string4 = outCircuitId = this.outCircuitIdSet ? this.outCircuitId : this.parentMessage.outCircuitId;
            if (outCircuitId == null) {
                throw new NullPointerException("Property outCircuitId must not be null");
            }
            return new OFCalientPortStatsEntryVer13(portNo, inAdminStatus, inOperStatus, inOperCapability, inAlarm, inportPower, outportPower, outAdminStatus, outOperStatus, outOperCapability, outAlarm, inCircuitId, outCircuitId);
        }
    }
}

