/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFCalientPortStatus;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortReason;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientPortDescStatsEntryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortReasonSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFCalientPortStatusVer13
implements OFCalientPortStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientPortStatusVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 64;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    private final OFPortReason reason;
    private final OFCalientPortDescStatsEntry desc;
    static final Reader READER = new Reader();
    static final OFCalientPortStatusVer13Funnel FUNNEL = new OFCalientPortStatusVer13Funnel();
    static final Writer WRITER = new Writer();

    OFCalientPortStatusVer13(long xid, OFPortReason reason, OFCalientPortDescStatsEntry desc) {
        if (reason == null) {
            throw new NullPointerException("OFCalientPortStatusVer13: property reason cannot be null");
        }
        if (desc == null) {
            throw new NullPointerException("OFCalientPortStatusVer13: property desc cannot be null");
        }
        this.xid = xid;
        this.reason = reason;
        this.desc = desc;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 8452440L;
    }

    @Override
    public long getSubtype() {
        return 1L;
    }

    @Override
    public OFPortReason getReason() {
        return this.reason;
    }

    @Override
    public OFCalientPortDescStatsEntry getDesc() {
        return this.desc;
    }

    @Override
    public OFCalientPortStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientPortStatusVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("desc=").append(this.desc);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFCalientPortStatusVer13 other = (OFCalientPortStatusVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.desc == null ? other.desc != null : !this.desc.equals(other.desc));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFCalientPortStatusVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFCalientPortStatusVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(8452440);
            bb.writeInt(1);
            OFPortReasonSerializerVer13.writeTo(bb, message.reason);
            bb.writeZero(7);
            message.desc.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFCalientPortStatusVer13Funnel
    implements Funnel<OFCalientPortStatusVer13> {
        private static final long serialVersionUID = 1L;

        OFCalientPortStatusVer13Funnel() {
        }

        public void funnel(OFCalientPortStatusVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(8452440);
            sink.putInt(1);
            OFPortReasonSerializerVer13.putTo(message.reason, sink);
            message.desc.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFCalientPortStatus> {
        Reader() {
        }

        @Override
        public OFCalientPortStatus readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 64) {
                throw new OFParseError("Wrong length: Expected to be >= 64, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 8452440) {
                throw new OFParseError("Wrong experimenter: Expected=0x80f958L(0x80f958L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 1) {
                throw new OFParseError("Wrong subtype: Expected=0x1L(0x1L), got=" + subtype);
            }
            OFPortReason reason = OFPortReasonSerializerVer13.readFrom(bb);
            bb.skipBytes(7);
            OFCalientPortDescStatsEntry desc = OFCalientPortDescStatsEntryVer13.READER.readFrom(bb);
            OFCalientPortStatusVer13 calientPortStatusVer13 = new OFCalientPortStatusVer13(xid, reason, desc);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)calientPortStatusVer13);
            }
            return calientPortStatusVer13;
        }
    }

    static class Builder
    implements OFCalientPortStatus.Builder {
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFPortReason reason;
        private boolean descSet;
        private OFCalientPortDescStatsEntry desc;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFCalientPortStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 8452440L;
        }

        @Override
        public long getSubtype() {
            return 1L;
        }

        @Override
        public OFPortReason getReason() {
            return this.reason;
        }

        @Override
        public OFCalientPortStatus.Builder setReason(OFPortReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFCalientPortDescStatsEntry getDesc() {
            return this.desc;
        }

        @Override
        public OFCalientPortStatus.Builder setDesc(OFCalientPortDescStatsEntry desc) {
            this.desc = desc;
            this.descSet = true;
            return this;
        }

        @Override
        public OFCalientPortStatus build() {
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            if (!this.descSet) {
                throw new IllegalStateException("Property desc doesn't have default value -- must be set");
            }
            if (this.desc == null) {
                throw new NullPointerException("Property desc must not be null");
            }
            return new OFCalientPortStatusVer13(xid, this.reason, this.desc);
        }
    }

    static class BuilderWithParent
    implements OFCalientPortStatus.Builder {
        final OFCalientPortStatusVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFPortReason reason;
        private boolean descSet;
        private OFCalientPortDescStatsEntry desc;

        BuilderWithParent(OFCalientPortStatusVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFCalientPortStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 8452440L;
        }

        @Override
        public long getSubtype() {
            return 1L;
        }

        @Override
        public OFPortReason getReason() {
            return this.reason;
        }

        @Override
        public OFCalientPortStatus.Builder setReason(OFPortReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFCalientPortDescStatsEntry getDesc() {
            return this.desc;
        }

        @Override
        public OFCalientPortStatus.Builder setDesc(OFCalientPortDescStatsEntry desc) {
            this.desc = desc;
            this.descSet = true;
            return this;
        }

        @Override
        public OFCalientPortStatus build() {
            OFCalientPortDescStatsEntry desc;
            OFPortReason reason;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPortReason oFPortReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            OFCalientPortDescStatsEntry oFCalientPortDescStatsEntry = desc = this.descSet ? this.desc : this.parentMessage.desc;
            if (desc == null) {
                throw new NullPointerException("Property desc must not be null");
            }
            return new OFCalientPortStatusVer13(xid, reason, desc);
        }
    }
}

