/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshC4;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmNshC4Ver13
implements OFOxmNshC4 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmNshC4Ver13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private final U32 value;
    static final OFOxmNshC4Ver13 DEFAULT = new OFOxmNshC4Ver13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmNshC4Ver13Funnel FUNNEL = new OFOxmNshC4Ver13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmNshC4Ver13(U32 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmNshC4Ver13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 125956L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.NSH_C4;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        return this;
    }

    @Override
    public U32 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmNshC4.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmNshC4Ver13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmNshC4Ver13 other = (OFOxmNshC4Ver13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmNshC4Ver13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmNshC4Ver13 message) {
            bb.writeInt(125956);
            bb.writeInt(message.value.getRaw());
        }
    }

    static class OFOxmNshC4Ver13Funnel
    implements Funnel<OFOxmNshC4Ver13> {
        private static final long serialVersionUID = 1L;

        OFOxmNshC4Ver13Funnel() {
        }

        public void funnel(OFOxmNshC4Ver13 message, PrimitiveSink sink) {
            sink.putInt(125956);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmNshC4> {
        Reader() {
        }

        @Override
        public OFOxmNshC4 readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 125956) {
                throw new OFParseError("Wrong typeLen: Expected=0x1ec04L(0x1ec04L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            OFOxmNshC4Ver13 oxmNshC4Ver13 = new OFOxmNshC4Ver13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmNshC4Ver13);
            }
            return oxmNshC4Ver13;
        }
    }

    static class Builder
    implements OFOxmNshC4.Builder {
        private boolean valueSet;
        private U32 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 125956L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNshC4.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.NSH_C4;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmNshC4 build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNshC4Ver13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmNshC4.Builder {
        final OFOxmNshC4Ver13 parentMessage;
        private boolean valueSet;
        private U32 value;

        BuilderWithParent(OFOxmNshC4Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 125956L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNshC4.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.NSH_C4;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmNshC4 build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNshC4Ver13(value);
        }
    }
}

