/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshMdtype;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmNshMdtypeVer13
implements OFOxmNshMdtype {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmNshMdtypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmNshMdtypeVer13 DEFAULT = new OFOxmNshMdtypeVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmNshMdtypeVer13Funnel FUNNEL = new OFOxmNshMdtypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmNshMdtypeVer13(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmNshMdtypeVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 126465L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.NSH_MDTYPE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmNshMdtype.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmNshMdtypeVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmNshMdtypeVer13 other = (OFOxmNshMdtypeVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmNshMdtypeVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmNshMdtypeVer13 message) {
            bb.writeInt(126465);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmNshMdtypeVer13Funnel
    implements Funnel<OFOxmNshMdtypeVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmNshMdtypeVer13Funnel() {
        }

        public void funnel(OFOxmNshMdtypeVer13 message, PrimitiveSink sink) {
            sink.putInt(126465);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmNshMdtype> {
        Reader() {
        }

        @Override
        public OFOxmNshMdtype readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 126465) {
                throw new OFParseError("Wrong typeLen: Expected=0x1ee01L(0x1ee01L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmNshMdtypeVer13 oxmNshMdtypeVer13 = new OFOxmNshMdtypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmNshMdtypeVer13);
            }
            return oxmNshMdtypeVer13;
        }
    }

    static class Builder
    implements OFOxmNshMdtype.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 126465L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNshMdtype.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.NSH_MDTYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmNshMdtype build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNshMdtypeVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmNshMdtype.Builder {
        final OFOxmNshMdtypeVer13 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmNshMdtypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 126465L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNshMdtype.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.NSH_MDTYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmNshMdtype build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNshMdtypeVer13(value);
        }
    }
}

