/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunGbpFlags;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTunGbpFlagsVer13
implements OFOxmTunGbpFlags {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTunGbpFlagsVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmTunGbpFlagsVer13 DEFAULT = new OFOxmTunGbpFlagsVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmTunGbpFlagsVer13Funnel FUNNEL = new OFOxmTunGbpFlagsVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTunGbpFlagsVer13(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmTunGbpFlagsVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 85505L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.TUN_GBP_FLAGS;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmTunGbpFlags.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTunGbpFlagsVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTunGbpFlagsVer13 other = (OFOxmTunGbpFlagsVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTunGbpFlagsVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmTunGbpFlagsVer13 message) {
            bb.writeInt(85505);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmTunGbpFlagsVer13Funnel
    implements Funnel<OFOxmTunGbpFlagsVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmTunGbpFlagsVer13Funnel() {
        }

        public void funnel(OFOxmTunGbpFlagsVer13 message, PrimitiveSink sink) {
            sink.putInt(85505);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTunGbpFlags> {
        Reader() {
        }

        @Override
        public OFOxmTunGbpFlags readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 85505) {
                throw new OFParseError("Wrong typeLen: Expected=0x14e01L(0x14e01L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmTunGbpFlagsVer13 oxmTunGbpFlagsVer13 = new OFOxmTunGbpFlagsVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTunGbpFlagsVer13);
            }
            return oxmTunGbpFlagsVer13;
        }
    }

    static class Builder
    implements OFOxmTunGbpFlags.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 85505L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunGbpFlags.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.TUN_GBP_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmTunGbpFlags build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunGbpFlagsVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmTunGbpFlags.Builder {
        final OFOxmTunGbpFlagsVer13 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmTunGbpFlagsVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 85505L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunGbpFlags.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.TUN_GBP_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmTunGbpFlags build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunGbpFlagsVer13(value);
        }
    }
}

