/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropInstructionsMiss;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionId;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionIdVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropInstructionsMissVer13
implements OFTableFeaturePropInstructionsMiss {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropInstructionsMissVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    private static final List<OFInstructionId> DEFAULT_INSTRUCTION_IDS = ImmutableList.of();
    private final List<OFInstructionId> instructionIds;
    static final OFTableFeaturePropInstructionsMissVer13 DEFAULT = new OFTableFeaturePropInstructionsMissVer13(DEFAULT_INSTRUCTION_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropInstructionsMissVer13Funnel FUNNEL = new OFTableFeaturePropInstructionsMissVer13Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropInstructionsMissVer13(List<OFInstructionId> instructionIds) {
        if (instructionIds == null) {
            throw new NullPointerException("OFTableFeaturePropInstructionsMissVer13: property instructionIds cannot be null");
        }
        this.instructionIds = instructionIds;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public List<OFInstructionId> getInstructionIds() {
        return this.instructionIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFTableFeaturePropInstructionsMiss.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropInstructionsMissVer13(");
        b.append("instructionIds=").append(this.instructionIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropInstructionsMissVer13 other = (OFTableFeaturePropInstructionsMissVer13)obj;
        return !(this.instructionIds == null ? other.instructionIds != null : !this.instructionIds.equals(other.instructionIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instructionIds == null ? 0 : this.instructionIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropInstructionsMissVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableFeaturePropInstructionsMissVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.instructionIds);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            bb.setShort(lengthIndex, length);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFTableFeaturePropInstructionsMissVer13Funnel
    implements Funnel<OFTableFeaturePropInstructionsMissVer13> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropInstructionsMissVer13Funnel() {
        }

        public void funnel(OFTableFeaturePropInstructionsMissVer13 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            FunnelUtils.putList(message.instructionIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropInstructionsMiss> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropInstructionsMiss readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFInstructionId> instructionIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFInstructionIdVer13.READER);
            bb.skipBytes((length + 7) / 8 * 8 - length);
            OFTableFeaturePropInstructionsMissVer13 tableFeaturePropInstructionsMissVer13 = new OFTableFeaturePropInstructionsMissVer13(instructionIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropInstructionsMissVer13);
            }
            return tableFeaturePropInstructionsMissVer13;
        }
    }

    static class Builder
    implements OFTableFeaturePropInstructionsMiss.Builder {
        private boolean instructionIdsSet;
        private List<OFInstructionId> instructionIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public List<OFInstructionId> getInstructionIds() {
            return this.instructionIds;
        }

        @Override
        public OFTableFeaturePropInstructionsMiss.Builder setInstructionIds(List<OFInstructionId> instructionIds) {
            this.instructionIds = instructionIds;
            this.instructionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFTableFeaturePropInstructionsMiss build() {
            List<OFInstructionId> instructionIds;
            List<OFInstructionId> list = instructionIds = this.instructionIdsSet ? this.instructionIds : DEFAULT_INSTRUCTION_IDS;
            if (instructionIds == null) {
                throw new NullPointerException("Property instructionIds must not be null");
            }
            return new OFTableFeaturePropInstructionsMissVer13(instructionIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropInstructionsMiss.Builder {
        final OFTableFeaturePropInstructionsMissVer13 parentMessage;
        private boolean instructionIdsSet;
        private List<OFInstructionId> instructionIds;

        BuilderWithParent(OFTableFeaturePropInstructionsMissVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public List<OFInstructionId> getInstructionIds() {
            return this.instructionIds;
        }

        @Override
        public OFTableFeaturePropInstructionsMiss.Builder setInstructionIds(List<OFInstructionId> instructionIds) {
            this.instructionIds = instructionIds;
            this.instructionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFTableFeaturePropInstructionsMiss build() {
            List instructionIds;
            List list = instructionIds = this.instructionIdsSet ? this.instructionIds : this.parentMessage.instructionIds;
            if (instructionIds == null) {
                throw new NullPointerException("Property instructionIds must not be null");
            }
            return new OFTableFeaturePropInstructionsMissVer13(instructionIds);
        }
    }
}

