/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdPopMpls;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdPopMplsVer14
implements OFActionIdPopMpls {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdPopMplsVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 4;
    static final OFActionIdPopMplsVer14 DEFAULT = new OFActionIdPopMplsVer14();
    static final OFActionIdPopMplsVer14 INSTANCE = new OFActionIdPopMplsVer14();
    static final Reader READER = new Reader();
    static final OFActionIdPopMplsVer14Funnel FUNNEL = new OFActionIdPopMplsVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdPopMplsVer14() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.POP_MPLS;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionIdPopMpls.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdPopMplsVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdPopMplsVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdPopMplsVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionIdPopMplsVer14 message) {
            bb.writeShort(20);
            bb.writeShort(4);
        }
    }

    static class OFActionIdPopMplsVer14Funnel
    implements Funnel<OFActionIdPopMplsVer14> {
        private static final long serialVersionUID = 1L;

        OFActionIdPopMplsVer14Funnel() {
        }

        public void funnel(OFActionIdPopMplsVer14 message, PrimitiveSink sink) {
            sink.putShort((short)20);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdPopMpls> {
        Reader() {
        }

        @Override
        public OFActionIdPopMpls readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 20) {
                throw new OFParseError("Wrong type: Expected=OFActionType.POP_MPLS(20), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

