/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionPushPbb;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionPushPbbVer14
implements OFActionPushPbb {
    private static final Logger logger = LoggerFactory.getLogger(OFActionPushPbbVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final EthType DEFAULT_ETHERTYPE = EthType.NONE;
    private final EthType ethertype;
    static final OFActionPushPbbVer14 DEFAULT = new OFActionPushPbbVer14(DEFAULT_ETHERTYPE);
    static final Reader READER = new Reader();
    static final OFActionPushPbbVer14Funnel FUNNEL = new OFActionPushPbbVer14Funnel();
    static final Writer WRITER = new Writer();

    OFActionPushPbbVer14(EthType ethertype) {
        if (ethertype == null) {
            throw new NullPointerException("OFActionPushPbbVer14: property ethertype cannot be null");
        }
        this.ethertype = ethertype;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.PUSH_PBB;
    }

    @Override
    public EthType getEthertype() {
        return this.ethertype;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionPushPbb.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionPushPbbVer14(");
        b.append("ethertype=").append(this.ethertype);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionPushPbbVer14 other = (OFActionPushPbbVer14)obj;
        return !(this.ethertype == null ? other.ethertype != null : !this.ethertype.equals(other.ethertype));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ethertype == null ? 0 : this.ethertype.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionPushPbbVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionPushPbbVer14 message) {
            bb.writeShort(26);
            bb.writeShort(8);
            message.ethertype.write2Bytes(bb);
            bb.writeZero(2);
        }
    }

    static class OFActionPushPbbVer14Funnel
    implements Funnel<OFActionPushPbbVer14> {
        private static final long serialVersionUID = 1L;

        OFActionPushPbbVer14Funnel() {
        }

        public void funnel(OFActionPushPbbVer14 message, PrimitiveSink sink) {
            sink.putShort((short)26);
            sink.putShort((short)8);
            message.ethertype.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionPushPbb> {
        Reader() {
        }

        @Override
        public OFActionPushPbb readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 26) {
                throw new OFParseError("Wrong type: Expected=OFActionType.PUSH_PBB(26), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            EthType ethertype = EthType.read2Bytes(bb);
            bb.skipBytes(2);
            OFActionPushPbbVer14 actionPushPbbVer14 = new OFActionPushPbbVer14(ethertype);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionPushPbbVer14);
            }
            return actionPushPbbVer14;
        }
    }

    static class Builder
    implements OFActionPushPbb.Builder {
        private boolean ethertypeSet;
        private EthType ethertype;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.PUSH_PBB;
        }

        @Override
        public EthType getEthertype() {
            return this.ethertype;
        }

        @Override
        public OFActionPushPbb.Builder setEthertype(EthType ethertype) {
            this.ethertype = ethertype;
            this.ethertypeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFActionPushPbb build() {
            EthType ethertype;
            EthType ethType = ethertype = this.ethertypeSet ? this.ethertype : DEFAULT_ETHERTYPE;
            if (ethertype == null) {
                throw new NullPointerException("Property ethertype must not be null");
            }
            return new OFActionPushPbbVer14(ethertype);
        }
    }

    static class BuilderWithParent
    implements OFActionPushPbb.Builder {
        final OFActionPushPbbVer14 parentMessage;
        private boolean ethertypeSet;
        private EthType ethertype;

        BuilderWithParent(OFActionPushPbbVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.PUSH_PBB;
        }

        @Override
        public EthType getEthertype() {
            return this.ethertype;
        }

        @Override
        public OFActionPushPbb.Builder setEthertype(EthType ethertype) {
            this.ethertype = ethertype;
            this.ethertypeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFActionPushPbb build() {
            EthType ethertype;
            EthType ethType = ethertype = this.ethertypeSet ? this.ethertype : this.parentMessage.ethertype;
            if (ethertype == null) {
                throw new NullPointerException("Property ethertype must not be null");
            }
            return new OFActionPushPbbVer14(ethertype);
        }
    }
}

