/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFControllerRoleReason;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFRoleProp;
import org.projectfloodlight.openflow.protocol.OFRoleStatus;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFControllerRoleReasonSerializerVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFRolePropVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFRoleStatusVer14
implements OFRoleStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFRoleStatusVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_ROLE = 0L;
    private static final U64 DEFAULT_GENERATION_ID = U64.ZERO;
    private static final List<OFRoleProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final long role;
    private final OFControllerRoleReason reason;
    private final U64 generationId;
    private final List<OFRoleProp> properties;
    static final Reader READER = new Reader();
    static final OFRoleStatusVer14Funnel FUNNEL = new OFRoleStatusVer14Funnel();
    static final Writer WRITER = new Writer();

    OFRoleStatusVer14(long xid, long role, OFControllerRoleReason reason, U64 generationId, List<OFRoleProp> properties) {
        if (reason == null) {
            throw new NullPointerException("OFRoleStatusVer14: property reason cannot be null");
        }
        if (generationId == null) {
            throw new NullPointerException("OFRoleStatusVer14: property generationId cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFRoleStatusVer14: property properties cannot be null");
        }
        this.xid = xid;
        this.role = role;
        this.reason = reason;
        this.generationId = generationId;
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.ROLE_STATUS;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getRole() {
        return this.role;
    }

    @Override
    public OFControllerRoleReason getReason() {
        return this.reason;
    }

    @Override
    public U64 getGenerationId() {
        return this.generationId;
    }

    @Override
    public List<OFRoleProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFRoleStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFRoleStatusVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("role=").append(this.role);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("generationId=").append(this.generationId);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFRoleStatusVer14 other = (OFRoleStatusVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.role != other.role) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.generationId == null ? other.generationId != null : !this.generationId.equals(other.generationId)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.role ^ this.role >>> 32);
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.generationId == null ? 0 : this.generationId.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFRoleStatusVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFRoleStatusVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(30);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(U32.t(message.role));
            OFControllerRoleReasonSerializerVer14.writeTo(bb, message.reason);
            bb.writeZero(3);
            bb.writeLong(message.generationId.getValue());
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFRoleStatusVer14Funnel
    implements Funnel<OFRoleStatusVer14> {
        private static final long serialVersionUID = 1L;

        OFRoleStatusVer14Funnel() {
        }

        public void funnel(OFRoleStatusVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)30);
            sink.putLong(message.xid);
            sink.putLong(message.role);
            OFControllerRoleReasonSerializerVer14.putTo(message.reason, sink);
            message.generationId.putTo(sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFRoleStatus> {
        Reader() {
        }

        @Override
        public OFRoleStatus readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 30) {
                throw new OFParseError("Wrong type: Expected=OFType.ROLE_STATUS(30), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            long role = U32.f(bb.readInt());
            OFControllerRoleReason reason = OFControllerRoleReasonSerializerVer14.readFrom(bb);
            bb.skipBytes(3);
            U64 generationId = U64.ofRaw(bb.readLong());
            List<OFRoleProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFRolePropVer14.READER);
            OFRoleStatusVer14 roleStatusVer14 = new OFRoleStatusVer14(xid, role, reason, generationId, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)roleStatusVer14);
            }
            return roleStatusVer14;
        }
    }

    static class Builder
    implements OFRoleStatus.Builder {
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private long role;
        private boolean reasonSet;
        private OFControllerRoleReason reason;
        private boolean generationIdSet;
        private U64 generationId;
        private boolean propertiesSet;
        private List<OFRoleProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.ROLE_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRoleStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getRole() {
            return this.role;
        }

        @Override
        public OFRoleStatus.Builder setRole(long role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFControllerRoleReason getReason() {
            return this.reason;
        }

        @Override
        public OFRoleStatus.Builder setReason(OFControllerRoleReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFRoleStatus.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public List<OFRoleProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFRoleStatus.Builder setProperties(List<OFRoleProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFRoleStatus build() {
            List<OFRoleProp> properties;
            U64 generationId;
            long role;
            long xid = this.xidSet ? this.xid : 0L;
            long l = role = this.roleSet ? this.role : 0L;
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            U64 u64 = generationId = this.generationIdSet ? this.generationId : DEFAULT_GENERATION_ID;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            List<OFRoleProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFRoleStatusVer14(xid, role, this.reason, generationId, properties);
        }
    }

    static class BuilderWithParent
    implements OFRoleStatus.Builder {
        final OFRoleStatusVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private long role;
        private boolean reasonSet;
        private OFControllerRoleReason reason;
        private boolean generationIdSet;
        private U64 generationId;
        private boolean propertiesSet;
        private List<OFRoleProp> properties;

        BuilderWithParent(OFRoleStatusVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.ROLE_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRoleStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getRole() {
            return this.role;
        }

        @Override
        public OFRoleStatus.Builder setRole(long role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFControllerRoleReason getReason() {
            return this.reason;
        }

        @Override
        public OFRoleStatus.Builder setReason(OFControllerRoleReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFRoleStatus.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public List<OFRoleProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFRoleStatus.Builder setProperties(List<OFRoleProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFRoleStatus build() {
            List properties;
            U64 generationId;
            OFControllerRoleReason reason;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long role = this.roleSet ? this.role : this.parentMessage.role;
            OFControllerRoleReason oFControllerRoleReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            U64 u64 = generationId = this.generationIdSet ? this.generationId : this.parentMessage.generationId;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFRoleStatusVer14(xid, role, reason, generationId, properties);
        }
    }
}

