/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropInstructions;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionId;
import org.projectfloodlight.openflow.protocol.ver14.OFInstructionIdVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropInstructionsVer14
implements OFTableFeaturePropInstructions {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropInstructionsVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final List<OFInstructionId> DEFAULT_INSTRUCTION_IDS = ImmutableList.of();
    private final List<OFInstructionId> instructionIds;
    static final OFTableFeaturePropInstructionsVer14 DEFAULT = new OFTableFeaturePropInstructionsVer14(DEFAULT_INSTRUCTION_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropInstructionsVer14Funnel FUNNEL = new OFTableFeaturePropInstructionsVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropInstructionsVer14(List<OFInstructionId> instructionIds) {
        if (instructionIds == null) {
            throw new NullPointerException("OFTableFeaturePropInstructionsVer14: property instructionIds cannot be null");
        }
        this.instructionIds = instructionIds;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public List<OFInstructionId> getInstructionIds() {
        return this.instructionIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableFeaturePropInstructions.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropInstructionsVer14(");
        b.append("instructionIds=").append(this.instructionIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropInstructionsVer14 other = (OFTableFeaturePropInstructionsVer14)obj;
        return !(this.instructionIds == null ? other.instructionIds != null : !this.instructionIds.equals(other.instructionIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instructionIds == null ? 0 : this.instructionIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropInstructionsVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableFeaturePropInstructionsVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(0);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.instructionIds);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropInstructionsVer14Funnel
    implements Funnel<OFTableFeaturePropInstructionsVer14> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropInstructionsVer14Funnel() {
        }

        public void funnel(OFTableFeaturePropInstructionsVer14 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            FunnelUtils.putList(message.instructionIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropInstructions> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropInstructions readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFInstructionId> instructionIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFInstructionIdVer14.READER);
            OFTableFeaturePropInstructionsVer14 tableFeaturePropInstructionsVer14 = new OFTableFeaturePropInstructionsVer14(instructionIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropInstructionsVer14);
            }
            return tableFeaturePropInstructionsVer14;
        }
    }

    static class Builder
    implements OFTableFeaturePropInstructions.Builder {
        private boolean instructionIdsSet;
        private List<OFInstructionId> instructionIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public List<OFInstructionId> getInstructionIds() {
            return this.instructionIds;
        }

        @Override
        public OFTableFeaturePropInstructions.Builder setInstructionIds(List<OFInstructionId> instructionIds) {
            this.instructionIds = instructionIds;
            this.instructionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropInstructions build() {
            List<OFInstructionId> instructionIds;
            List<OFInstructionId> list = instructionIds = this.instructionIdsSet ? this.instructionIds : DEFAULT_INSTRUCTION_IDS;
            if (instructionIds == null) {
                throw new NullPointerException("Property instructionIds must not be null");
            }
            return new OFTableFeaturePropInstructionsVer14(instructionIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropInstructions.Builder {
        final OFTableFeaturePropInstructionsVer14 parentMessage;
        private boolean instructionIdsSet;
        private List<OFInstructionId> instructionIds;

        BuilderWithParent(OFTableFeaturePropInstructionsVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public List<OFInstructionId> getInstructionIds() {
            return this.instructionIds;
        }

        @Override
        public OFTableFeaturePropInstructions.Builder setInstructionIds(List<OFInstructionId> instructionIds) {
            this.instructionIds = instructionIds;
            this.instructionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropInstructions build() {
            List instructionIds;
            List list = instructionIds = this.instructionIdsSet ? this.instructionIds : this.parentMessage.instructionIds;
            if (instructionIds == null) {
                throw new NullPointerException("Property instructionIds must not be null");
            }
            return new OFTableFeaturePropInstructionsVer14(instructionIds);
        }
    }
}

