/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

public class IPv6FlowLabel
implements OFValueType<IPv6FlowLabel> {
    static final int LENGTH = 4;
    private final int label;
    private static final int NONE_VAL = 0;
    public static final IPv6FlowLabel NONE = new IPv6FlowLabel(0);
    public static final IPv6FlowLabel NO_MASK = IPv6FlowLabel.of(-1);
    public static final IPv6FlowLabel FULL_MASK = IPv6FlowLabel.of(0);

    private IPv6FlowLabel(int label) {
        this.label = label;
    }

    public static IPv6FlowLabel of(int label) {
        if (label == 0) {
            return NONE;
        }
        return new IPv6FlowLabel(label);
    }

    @Override
    public int getLength() {
        return 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IPv6FlowLabel)) {
            return false;
        }
        IPv6FlowLabel other = (IPv6FlowLabel)obj;
        return other.label == this.label;
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        result = 59 * result + this.label;
        return result;
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.label);
    }

    public void write4Bytes(ChannelBuffer c) {
        c.writeInt(this.label);
    }

    public static IPv6FlowLabel read4Bytes(ChannelBuffer c) throws OFParseError {
        return IPv6FlowLabel.of((int)(c.readUnsignedInt() & 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public IPv6FlowLabel applyMask(IPv6FlowLabel mask) {
        return IPv6FlowLabel.of(this.label & mask.label);
    }

    public int getIPv6FlowLabelValue() {
        return this.label;
    }

    @Override
    public int compareTo(IPv6FlowLabel o) {
        return UnsignedInts.compare((int)this.label, (int)o.label);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.label);
    }
}

