/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.collect.ComparisonChain;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedBytes;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;

public class OduSignalID
implements OFValueType<OduSignalID> {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    private static final int DEFAULT_TPN = 0;
    private static final int DEFAULT_TSLEN = 80;
    private static final byte[] DEFAULT_TSMAP = new byte[10];
    private final int tpn;
    private final int tslen;
    private final byte[] tsmap;
    public static final OduSignalID DEFAULT = new OduSignalID(0, 80, DEFAULT_TSMAP);
    static final OduSignalIDFunnel FUNNEL = new OduSignalIDFunnel();

    public OduSignalID(int tpn, int tslen, byte[] tsmap) {
        this.tpn = tpn;
        this.tslen = tslen;
        this.tsmap = tsmap;
    }

    public int getTpn() {
        return this.tpn;
    }

    public int getTslen() {
        return this.tslen;
    }

    public byte[] getTsmap() {
        return this.tsmap;
    }

    @Override
    public int getLength() {
        return 16;
    }

    public void writeTo(ChannelBuffer c) {
        c.writeShort(this.tpn);
        c.writeShort(this.tslen);
        c.writeBytes(this.tsmap);
        c.writeZero(2);
    }

    public static OduSignalID readFrom(ChannelBuffer c) {
        int tpn = U16.f(c.readShort());
        int tslen = U16.f(c.readShort());
        byte[] tsmap = null;
        tsmap = ChannelUtils.readBytes(c, 10);
        ChannelUtils.readBytes(c, 2);
        OduSignalID oduSigId = new OduSignalID(tpn, tslen, tsmap);
        return oduSigId;
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(" OduSignalID(");
        b.append("tpn=").append(this.tpn);
        b.append(", ");
        b.append("tslen=").append(this.tslen);
        b.append(", ");
        b.append("tsmap=").append(Arrays.toString(this.tsmap));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OduSignalID other = (OduSignalID)obj;
        if (this.tpn != other.tpn) {
            return false;
        }
        if (this.tslen != other.tslen) {
            return false;
        }
        return Arrays.equals(this.tsmap, other.tsmap);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.tpn;
        result = 31 * result + this.tslen;
        result = 31 * result + Arrays.hashCode(this.tsmap);
        return result;
    }

    @Override
    public OduSignalID applyMask(OduSignalID mask) {
        byte[] maskTsmap = null;
        if (this.tsmap != null && this.tsmap.length > 0) {
            maskTsmap = new byte[this.tsmap.length];
            int i = 0;
            for (byte b : this.tsmap) {
                maskTsmap[i] = (byte)(b & mask.tsmap[i++]);
            }
        }
        return new OduSignalID(this.tpn & mask.tpn, (short)(this.tslen & mask.tslen), maskTsmap);
    }

    @Override
    public int compareTo(OduSignalID o) {
        return ComparisonChain.start().compare(this.tpn, o.tpn).compare(this.tslen, o.tslen).compare((Object)this.tsmap, (Object)o.tsmap, UnsignedBytes.lexicographicalComparator()).result();
    }

    static class OduSignalIDFunnel
    implements Funnel<OduSignalID> {
        private static final long serialVersionUID = 1L;

        OduSignalIDFunnel() {
        }

        public void funnel(OduSignalID message, PrimitiveSink sink) {
            sink.putInt(message.tpn);
            sink.putInt(message.tslen);
            sink.putBytes(message.tsmap);
        }
    }
}

