// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver12;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOxmArpOpVer12 implements OFOxmArpOp {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmArpOpVer12.class);
    // version: 1.2
    final static byte WIRE_VERSION = 3;
    final static int LENGTH = 6;

        private final static ArpOpcode DEFAULT_VALUE = ArpOpcode.NONE;

    // OF message fields
    private final ArpOpcode value;
//
    // Immutable default instance
    final static OFOxmArpOpVer12 DEFAULT = new OFOxmArpOpVer12(
        DEFAULT_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFOxmArpOpVer12(ArpOpcode value) {
        if(value == null) {
            throw new NullPointerException("OFOxmArpOpVer12: property value cannot be null");
        }
        this.value = value;
    }

    // Accessors for OF message fields
    @Override
    public long getTypeLen() {
        return 0x80002a02L;
    }

    @Override
    public ArpOpcode getValue() {
        return value;
    }

    @Override
    public MatchField<ArpOpcode> getMatchField() {
        return MatchField.ARP_OP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    public OFOxm<ArpOpcode> getCanonical() {
        // exact match OXM is always canonical
        return this;
    }

    @Override
    public ArpOpcode getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }



    public OFOxmArpOp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOxmArpOp.Builder {
        final OFOxmArpOpVer12 parentMessage;

        // OF message fields
        private boolean valueSet;
        private ArpOpcode value;

        BuilderWithParent(OFOxmArpOpVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public long getTypeLen() {
        return 0x80002a02L;
    }

    @Override
    public ArpOpcode getValue() {
        return value;
    }

    @Override
    public OFOxmArpOp.Builder setValue(ArpOpcode value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<ArpOpcode> getMatchField() {
        return MatchField.ARP_OP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<ArpOpcode> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
    }

    @Override
    public ArpOpcode getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }



        @Override
        public OFOxmArpOp build() {
                ArpOpcode value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");

                //
                return new OFOxmArpOpVer12(
                    value
                );
        }

    }

    static class Builder implements OFOxmArpOp.Builder {
        // OF message fields
        private boolean valueSet;
        private ArpOpcode value;

    @Override
    public long getTypeLen() {
        return 0x80002a02L;
    }

    @Override
    public ArpOpcode getValue() {
        return value;
    }

    @Override
    public OFOxmArpOp.Builder setValue(ArpOpcode value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<ArpOpcode> getMatchField() {
        return MatchField.ARP_OP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<ArpOpcode> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
    }

    @Override
    public ArpOpcode getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

//
        @Override
        public OFOxmArpOp build() {
            ArpOpcode value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");


            return new OFOxmArpOpVer12(
                    value
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOxmArpOp> {
        @Override
        public OFOxmArpOp readFrom(ChannelBuffer bb) throws OFParseError {
            // fixed value property typeLen == 0x80002a02L
            int typeLen = bb.readInt();
            if(typeLen != (int) 0x80002a02)
                throw new OFParseError("Wrong typeLen: Expected=0x80002a02L(0x80002a02L), got="+typeLen);
            ArpOpcode value = ArpOpcode.read2Bytes(bb);

            OFOxmArpOpVer12 oxmArpOpVer12 = new OFOxmArpOpVer12(
                    value
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oxmArpOpVer12);
            return oxmArpOpVer12;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOxmArpOpVer12Funnel FUNNEL = new OFOxmArpOpVer12Funnel();
    static class OFOxmArpOpVer12Funnel implements Funnel<OFOxmArpOpVer12> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOxmArpOpVer12 message, PrimitiveSink sink) {
            // fixed value property typeLen = 0x80002a02L
            sink.putInt((int) 0x80002a02);
            message.value.putTo(sink);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOxmArpOpVer12> {
        @Override
        public void write(ChannelBuffer bb, OFOxmArpOpVer12 message) {
            // fixed value property typeLen = 0x80002a02L
            bb.writeInt((int) 0x80002a02);
            message.value.write2Bytes(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmArpOpVer12(");
        b.append("value=").append(value);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOxmArpOpVer12 other = (OFOxmArpOpVer12) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

}
