// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFCalientPortStatusVer13 implements OFCalientPortStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientPortStatusVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int MINIMUM_LENGTH = 64;

        private final static long DEFAULT_XID = 0x0L;

    // OF message fields
    private final long xid;
    private final OFPortReason reason;
    private final OFCalientPortDescStatsEntry desc;
//

    // package private constructor - used by readers, builders, and factory
    OFCalientPortStatusVer13(long xid, OFPortReason reason, OFCalientPortDescStatsEntry desc) {
        if(reason == null) {
            throw new NullPointerException("OFCalientPortStatusVer13: property reason cannot be null");
        }
        if(desc == null) {
            throw new NullPointerException("OFCalientPortStatusVer13: property desc cannot be null");
        }
        this.xid = xid;
        this.reason = reason;
        this.desc = desc;
    }

    // Accessors for OF message fields
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public long getExperimenter() {
        return 0x80f958L;
    }

    @Override
    public long getSubtype() {
        return 0x1L;
    }

    @Override
    public OFPortReason getReason() {
        return reason;
    }

    @Override
    public OFCalientPortDescStatsEntry getDesc() {
        return desc;
    }



    public OFCalientPortStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFCalientPortStatus.Builder {
        final OFCalientPortStatusVer13 parentMessage;

        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFPortReason reason;
        private boolean descSet;
        private OFCalientPortDescStatsEntry desc;

        BuilderWithParent(OFCalientPortStatusVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFCalientPortStatus.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public long getExperimenter() {
        return 0x80f958L;
    }

    @Override
    public long getSubtype() {
        return 0x1L;
    }

    @Override
    public OFPortReason getReason() {
        return reason;
    }

    @Override
    public OFCalientPortStatus.Builder setReason(OFPortReason reason) {
        this.reason = reason;
        this.reasonSet = true;
        return this;
    }
    @Override
    public OFCalientPortDescStatsEntry getDesc() {
        return desc;
    }

    @Override
    public OFCalientPortStatus.Builder setDesc(OFCalientPortDescStatsEntry desc) {
        this.desc = desc;
        this.descSet = true;
        return this;
    }


        @Override
        public OFCalientPortStatus build() {
                long xid = this.xidSet ? this.xid : parentMessage.xid;
                OFPortReason reason = this.reasonSet ? this.reason : parentMessage.reason;
                if(reason == null)
                    throw new NullPointerException("Property reason must not be null");
                OFCalientPortDescStatsEntry desc = this.descSet ? this.desc : parentMessage.desc;
                if(desc == null)
                    throw new NullPointerException("Property desc must not be null");

                //
                return new OFCalientPortStatusVer13(
                    xid,
                    reason,
                    desc
                );
        }

    }

    static class Builder implements OFCalientPortStatus.Builder {
        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFPortReason reason;
        private boolean descSet;
        private OFCalientPortDescStatsEntry desc;

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFCalientPortStatus.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public long getExperimenter() {
        return 0x80f958L;
    }

    @Override
    public long getSubtype() {
        return 0x1L;
    }

    @Override
    public OFPortReason getReason() {
        return reason;
    }

    @Override
    public OFCalientPortStatus.Builder setReason(OFPortReason reason) {
        this.reason = reason;
        this.reasonSet = true;
        return this;
    }
    @Override
    public OFCalientPortDescStatsEntry getDesc() {
        return desc;
    }

    @Override
    public OFCalientPortStatus.Builder setDesc(OFCalientPortDescStatsEntry desc) {
        this.desc = desc;
        this.descSet = true;
        return this;
    }
//
        @Override
        public OFCalientPortStatus build() {
            long xid = this.xidSet ? this.xid : DEFAULT_XID;
            if(!this.reasonSet)
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            if(reason == null)
                throw new NullPointerException("Property reason must not be null");
            if(!this.descSet)
                throw new IllegalStateException("Property desc doesn't have default value -- must be set");
            if(desc == null)
                throw new NullPointerException("Property desc must not be null");


            return new OFCalientPortStatusVer13(
                    xid,
                    reason,
                    desc
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFCalientPortStatus> {
        @Override
        public OFCalientPortStatus readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property version == 4
            byte version = bb.readByte();
            if(version != (byte) 0x4)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got="+version);
            // fixed value property type == 4
            byte type = bb.readByte();
            if(type != (byte) 0x4)
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            long xid = U32.f(bb.readInt());
            // fixed value property experimenter == 0x80f958L
            int experimenter = bb.readInt();
            if(experimenter != 0x80f958)
                throw new OFParseError("Wrong experimenter: Expected=0x80f958L(0x80f958L), got="+experimenter);
            // fixed value property subtype == 0x1L
            int subtype = bb.readInt();
            if(subtype != 0x1)
                throw new OFParseError("Wrong subtype: Expected=0x1L(0x1L), got="+subtype);
            OFPortReason reason = OFPortReasonSerializerVer13.readFrom(bb);
            // pad: 7 bytes
            bb.skipBytes(7);
            OFCalientPortDescStatsEntry desc = OFCalientPortDescStatsEntryVer13.READER.readFrom(bb);

            OFCalientPortStatusVer13 calientPortStatusVer13 = new OFCalientPortStatusVer13(
                    xid,
                      reason,
                      desc
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", calientPortStatusVer13);
            return calientPortStatusVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFCalientPortStatusVer13Funnel FUNNEL = new OFCalientPortStatusVer13Funnel();
    static class OFCalientPortStatusVer13Funnel implements Funnel<OFCalientPortStatusVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFCalientPortStatusVer13 message, PrimitiveSink sink) {
            // fixed value property version = 4
            sink.putByte((byte) 0x4);
            // fixed value property type = 4
            sink.putByte((byte) 0x4);
            // FIXME: skip funnel of length
            sink.putLong(message.xid);
            // fixed value property experimenter = 0x80f958L
            sink.putInt(0x80f958);
            // fixed value property subtype = 0x1L
            sink.putInt(0x1);
            OFPortReasonSerializerVer13.putTo(message.reason, sink);
            // skip pad (7 bytes)
            message.desc.putTo(sink);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFCalientPortStatusVer13> {
        @Override
        public void write(ChannelBuffer bb, OFCalientPortStatusVer13 message) {
            int startIndex = bb.writerIndex();
            // fixed value property version = 4
            bb.writeByte((byte) 0x4);
            // fixed value property type = 4
            bb.writeByte((byte) 0x4);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            bb.writeInt(U32.t(message.xid));
            // fixed value property experimenter = 0x80f958L
            bb.writeInt(0x80f958);
            // fixed value property subtype = 0x1L
            bb.writeInt(0x1);
            OFPortReasonSerializerVer13.writeTo(bb, message.reason);
            // pad: 7 bytes
            bb.writeZero(7);
            message.desc.writeTo(bb);

            // update length field
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientPortStatusVer13(");
        b.append("xid=").append(xid);
        b.append(", ");
        b.append("reason=").append(reason);
        b.append(", ");
        b.append("desc=").append(desc);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFCalientPortStatusVer13 other = (OFCalientPortStatusVer13) obj;

        if( xid != other.xid)
            return false;
        if (reason == null) {
            if (other.reason != null)
                return false;
        } else if (!reason.equals(other.reason))
            return false;
        if (desc == null) {
            if (other.desc != null)
                return false;
        } else if (!desc.equals(other.desc))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (xid ^ (xid >>> 32));
        result = prime * result + ((reason == null) ? 0 : reason.hashCode());
        result = prime * result + ((desc == null) ? 0 : desc.hashCode());
        return result;
    }

}
