// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFExpExtAdidSonetVer13 implements OFExpExtAdidSonet {
    private static final Logger logger = LoggerFactory.getLogger(OFExpExtAdidSonetVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 24;

        private final static int DEFAULT_TYPE = 0x0;
        private final static OFBitMask128 DEFAULT_ID = OFBitMask128.NONE;

    // OF message fields
    private final int type;
    private final OFBitMask128 id;
//
    // Immutable default instance
    final static OFExpExtAdidSonetVer13 DEFAULT = new OFExpExtAdidSonetVer13(
        DEFAULT_TYPE, DEFAULT_ID
    );

    // package private constructor - used by readers, builders, and factory
    OFExpExtAdidSonetVer13(int type, OFBitMask128 id) {
        if(id == null) {
            throw new NullPointerException("OFExpExtAdidSonetVer13: property id cannot be null");
        }
        this.type = type;
        this.id = id;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return type;
    }

    @Override
    public int getNamespace() {
        return 0x0;
    }

    @Override
    public int getNsType() {
        return 0x1;
    }

    @Override
    public OFBitMask128 getId() {
        return id;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFExpExtAdidSonet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFExpExtAdidSonet.Builder {
        final OFExpExtAdidSonetVer13 parentMessage;

        // OF message fields
        private boolean typeSet;
        private int type;
        private boolean idSet;
        private OFBitMask128 id;

        BuilderWithParent(OFExpExtAdidSonetVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return type;
    }

    @Override
    public OFExpExtAdidSonet.Builder setType(int type) {
        this.type = type;
        this.typeSet = true;
        return this;
    }
    @Override
    public int getNamespace() {
        return 0x0;
    }

    @Override
    public int getNsType() {
        return 0x1;
    }

    @Override
    public OFBitMask128 getId() {
        return id;
    }

    @Override
    public OFExpExtAdidSonet.Builder setId(OFBitMask128 id) {
        this.id = id;
        this.idSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFExpExtAdidSonet build() {
                int type = this.typeSet ? this.type : parentMessage.type;
                OFBitMask128 id = this.idSet ? this.id : parentMessage.id;
                if(id == null)
                    throw new NullPointerException("Property id must not be null");

                //
                return new OFExpExtAdidSonetVer13(
                    type,
                    id
                );
        }

    }

    static class Builder implements OFExpExtAdidSonet.Builder {
        // OF message fields
        private boolean typeSet;
        private int type;
        private boolean idSet;
        private OFBitMask128 id;

    @Override
    public int getType() {
        return type;
    }

    @Override
    public OFExpExtAdidSonet.Builder setType(int type) {
        this.type = type;
        this.typeSet = true;
        return this;
    }
    @Override
    public int getNamespace() {
        return 0x0;
    }

    @Override
    public int getNsType() {
        return 0x1;
    }

    @Override
    public OFBitMask128 getId() {
        return id;
    }

    @Override
    public OFExpExtAdidSonet.Builder setId(OFBitMask128 id) {
        this.id = id;
        this.idSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFExpExtAdidSonet build() {
            int type = this.typeSet ? this.type : DEFAULT_TYPE;
            OFBitMask128 id = this.idSet ? this.id : DEFAULT_ID;
            if(id == null)
                throw new NullPointerException("Property id must not be null");


            return new OFExpExtAdidSonetVer13(
                    type,
                    id
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFExpExtAdidSonet> {
        @Override
        public OFExpExtAdidSonet readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int type = U16.f(bb.readShort());
            int length = U16.f(bb.readShort());
            if(length != 24)
                throw new OFParseError("Wrong length: Expected=24(24), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // fixed value property namespace == 0x0
            short namespace = bb.readShort();
            if(namespace != (short) 0x0)
                throw new OFParseError("Wrong namespace: Expected=0x0(0x0), got="+namespace);
            // fixed value property nsType == 0x1
            short nsType = bb.readShort();
            if(nsType != (short) 0x1)
                throw new OFParseError("Wrong nsType: Expected=0x1(0x1), got="+nsType);
            OFBitMask128 id = OFBitMask128.read16Bytes(bb);

            OFExpExtAdidSonetVer13 expExtAdidSonetVer13 = new OFExpExtAdidSonetVer13(
                    type,
                      id
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", expExtAdidSonetVer13);
            return expExtAdidSonetVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFExpExtAdidSonetVer13Funnel FUNNEL = new OFExpExtAdidSonetVer13Funnel();
    static class OFExpExtAdidSonetVer13Funnel implements Funnel<OFExpExtAdidSonetVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFExpExtAdidSonetVer13 message, PrimitiveSink sink) {
            sink.putInt(message.type);
            // fixed value property length = 24
            sink.putShort((short) 0x18);
            // fixed value property namespace = 0x0
            sink.putShort((short) 0x0);
            // fixed value property nsType = 0x1
            sink.putShort((short) 0x1);
            message.id.putTo(sink);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFExpExtAdidSonetVer13> {
        @Override
        public void write(ChannelBuffer bb, OFExpExtAdidSonetVer13 message) {
            bb.writeShort(U16.t(message.type));
            // fixed value property length = 24
            bb.writeShort((short) 0x18);
            // fixed value property namespace = 0x0
            bb.writeShort((short) 0x0);
            // fixed value property nsType = 0x1
            bb.writeShort((short) 0x1);
            message.id.write16Bytes(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFExpExtAdidSonetVer13(");
        b.append("type=").append(type);
        b.append(", ");
        b.append("id=").append(id);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFExpExtAdidSonetVer13 other = (OFExpExtAdidSonetVer13) obj;

        if( type != other.type)
            return false;
        if (id == null) {
            if (other.id != null)
                return false;
        } else if (!id.equals(other.id))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + type;
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        return result;
    }

}
