// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOxmExpOduSigIdVer13 implements OFOxmExpOduSigId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmExpOduSigIdVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 24;

        private final static OduSignalID DEFAULT_VALUE = OduSignalID.DEFAULT;

    // OF message fields
    private final OduSignalID value;
//
    // Immutable default instance
    final static OFOxmExpOduSigIdVer13 DEFAULT = new OFOxmExpOduSigIdVer13(
        DEFAULT_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFOxmExpOduSigIdVer13(OduSignalID value) {
        if(value == null) {
            throw new NullPointerException("OFOxmExpOduSigIdVer13: property value cannot be null");
        }
        this.value = value;
    }

    // Accessors for OF message fields
    @Override
    public long getTypeLen() {
        return 0xffff0610L;
    }

    @Override
    public long getExperimenter() {
        return 0xff000007L;
    }

    @Override
    public OduSignalID getValue() {
        return value;
    }

    @Override
    public MatchField<OduSignalID> getMatchField() {
        return MatchField.EXP_ODU_SIG_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    public OFOxm<OduSignalID> getCanonical() {
        // exact match OXM is always canonical
        return this;
    }

    @Override
    public OduSignalID getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFOxmExpOduSigId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOxmExpOduSigId.Builder {
        final OFOxmExpOduSigIdVer13 parentMessage;

        // OF message fields
        private boolean valueSet;
        private OduSignalID value;

        BuilderWithParent(OFOxmExpOduSigIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public long getTypeLen() {
        return 0xffff0610L;
    }

    @Override
    public long getExperimenter() {
        return 0xff000007L;
    }

    @Override
    public OduSignalID getValue() {
        return value;
    }

    @Override
    public OFOxmExpOduSigId.Builder setValue(OduSignalID value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<OduSignalID> getMatchField() {
        return MatchField.EXP_ODU_SIG_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OduSignalID> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
    }

    @Override
    public OduSignalID getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFOxmExpOduSigId build() {
                OduSignalID value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");

                //
                return new OFOxmExpOduSigIdVer13(
                    value
                );
        }

    }

    static class Builder implements OFOxmExpOduSigId.Builder {
        // OF message fields
        private boolean valueSet;
        private OduSignalID value;

    @Override
    public long getTypeLen() {
        return 0xffff0610L;
    }

    @Override
    public long getExperimenter() {
        return 0xff000007L;
    }

    @Override
    public OduSignalID getValue() {
        return value;
    }

    @Override
    public OFOxmExpOduSigId.Builder setValue(OduSignalID value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<OduSignalID> getMatchField() {
        return MatchField.EXP_ODU_SIG_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OduSignalID> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
    }

    @Override
    public OduSignalID getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFOxmExpOduSigId build() {
            OduSignalID value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");


            return new OFOxmExpOduSigIdVer13(
                    value
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOxmExpOduSigId> {
        @Override
        public OFOxmExpOduSigId readFrom(ChannelBuffer bb) throws OFParseError {
            // fixed value property typeLen == 0xffff0610L
            int typeLen = bb.readInt();
            if(typeLen != (int) 0xffff0610)
                throw new OFParseError("Wrong typeLen: Expected=0xffff0610L(0xffff0610L), got="+typeLen);
            // fixed value property experimenter == 0xff000007L
            int experimenter = bb.readInt();
            if(experimenter != (int) 0xff000007)
                throw new OFParseError("Wrong experimenter: Expected=0xff000007L(0xff000007L), got="+experimenter);
            OduSignalID value = OduSignalID.readFrom(bb);

            OFOxmExpOduSigIdVer13 oxmExpOduSigIdVer13 = new OFOxmExpOduSigIdVer13(
                    value
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oxmExpOduSigIdVer13);
            return oxmExpOduSigIdVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOxmExpOduSigIdVer13Funnel FUNNEL = new OFOxmExpOduSigIdVer13Funnel();
    static class OFOxmExpOduSigIdVer13Funnel implements Funnel<OFOxmExpOduSigIdVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOxmExpOduSigIdVer13 message, PrimitiveSink sink) {
            // fixed value property typeLen = 0xffff0610L
            sink.putInt((int) 0xffff0610);
            // fixed value property experimenter = 0xff000007L
            sink.putInt((int) 0xff000007);
            message.value.putTo(sink);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOxmExpOduSigIdVer13> {
        @Override
        public void write(ChannelBuffer bb, OFOxmExpOduSigIdVer13 message) {
            // fixed value property typeLen = 0xffff0610L
            bb.writeInt((int) 0xffff0610);
            // fixed value property experimenter = 0xff000007L
            bb.writeInt((int) 0xff000007);
            message.value.writeTo(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmExpOduSigIdVer13(");
        b.append("value=").append(value);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOxmExpOduSigIdVer13 other = (OFOxmExpOduSigIdVer13) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

}
