// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFPortOpticalTransportApplicationCodeVer13 implements OFPortOpticalTransportApplicationCode {
    private static final Logger logger = LoggerFactory.getLogger(OFPortOpticalTransportApplicationCodeVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 18;

        private final static int DEFAULT_FEATURE_TYPE = 0x0;
        private final static short DEFAULT_OIC_TYPE = (short) 0x0;
        private final static String DEFAULT_APP_CODE = "";

    // OF message fields
    private final int featureType;
    private final short oicType;
    private final String appCode;
//
    // Immutable default instance
    final static OFPortOpticalTransportApplicationCodeVer13 DEFAULT = new OFPortOpticalTransportApplicationCodeVer13(
        DEFAULT_FEATURE_TYPE, DEFAULT_OIC_TYPE, DEFAULT_APP_CODE
    );

    // package private constructor - used by readers, builders, and factory
    OFPortOpticalTransportApplicationCodeVer13(int featureType, short oicType, String appCode) {
        if(appCode == null) {
            throw new NullPointerException("OFPortOpticalTransportApplicationCodeVer13: property appCode cannot be null");
        }
        this.featureType = featureType;
        this.oicType = oicType;
        this.appCode = appCode;
    }

    // Accessors for OF message fields
    @Override
    public int getFeatureType() {
        return featureType;
    }

    @Override
    public short getOicType() {
        return oicType;
    }

    @Override
    public String getAppCode() {
        return appCode;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFPortOpticalTransportApplicationCode.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFPortOpticalTransportApplicationCode.Builder {
        final OFPortOpticalTransportApplicationCodeVer13 parentMessage;

        // OF message fields
        private boolean featureTypeSet;
        private int featureType;
        private boolean oicTypeSet;
        private short oicType;
        private boolean appCodeSet;
        private String appCode;

        BuilderWithParent(OFPortOpticalTransportApplicationCodeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getFeatureType() {
        return featureType;
    }

    @Override
    public OFPortOpticalTransportApplicationCode.Builder setFeatureType(int featureType) {
        this.featureType = featureType;
        this.featureTypeSet = true;
        return this;
    }
    @Override
    public short getOicType() {
        return oicType;
    }

    @Override
    public OFPortOpticalTransportApplicationCode.Builder setOicType(short oicType) {
        this.oicType = oicType;
        this.oicTypeSet = true;
        return this;
    }
    @Override
    public String getAppCode() {
        return appCode;
    }

    @Override
    public OFPortOpticalTransportApplicationCode.Builder setAppCode(String appCode) {
        this.appCode = appCode;
        this.appCodeSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFPortOpticalTransportApplicationCode build() {
                int featureType = this.featureTypeSet ? this.featureType : parentMessage.featureType;
                short oicType = this.oicTypeSet ? this.oicType : parentMessage.oicType;
                String appCode = this.appCodeSet ? this.appCode : parentMessage.appCode;
                if(appCode == null)
                    throw new NullPointerException("Property appCode must not be null");

                //
                return new OFPortOpticalTransportApplicationCodeVer13(
                    featureType,
                    oicType,
                    appCode
                );
        }

    }

    static class Builder implements OFPortOpticalTransportApplicationCode.Builder {
        // OF message fields
        private boolean featureTypeSet;
        private int featureType;
        private boolean oicTypeSet;
        private short oicType;
        private boolean appCodeSet;
        private String appCode;

    @Override
    public int getFeatureType() {
        return featureType;
    }

    @Override
    public OFPortOpticalTransportApplicationCode.Builder setFeatureType(int featureType) {
        this.featureType = featureType;
        this.featureTypeSet = true;
        return this;
    }
    @Override
    public short getOicType() {
        return oicType;
    }

    @Override
    public OFPortOpticalTransportApplicationCode.Builder setOicType(short oicType) {
        this.oicType = oicType;
        this.oicTypeSet = true;
        return this;
    }
    @Override
    public String getAppCode() {
        return appCode;
    }

    @Override
    public OFPortOpticalTransportApplicationCode.Builder setAppCode(String appCode) {
        this.appCode = appCode;
        this.appCodeSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFPortOpticalTransportApplicationCode build() {
            int featureType = this.featureTypeSet ? this.featureType : DEFAULT_FEATURE_TYPE;
            short oicType = this.oicTypeSet ? this.oicType : DEFAULT_OIC_TYPE;
            String appCode = this.appCodeSet ? this.appCode : DEFAULT_APP_CODE;
            if(appCode == null)
                throw new NullPointerException("Property appCode must not be null");


            return new OFPortOpticalTransportApplicationCodeVer13(
                    featureType,
                    oicType,
                    appCode
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFPortOpticalTransportApplicationCode> {
        @Override
        public OFPortOpticalTransportApplicationCode readFrom(ChannelBuffer bb) throws OFParseError {
            int featureType = U16.f(bb.readShort());
            short oicType = U8.f(bb.readByte());
            String appCode = ChannelUtils.readFixedLengthString(bb, 15);

            OFPortOpticalTransportApplicationCodeVer13 portOpticalTransportApplicationCodeVer13 = new OFPortOpticalTransportApplicationCodeVer13(
                    featureType,
                      oicType,
                      appCode
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", portOpticalTransportApplicationCodeVer13);
            return portOpticalTransportApplicationCodeVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFPortOpticalTransportApplicationCodeVer13Funnel FUNNEL = new OFPortOpticalTransportApplicationCodeVer13Funnel();
    static class OFPortOpticalTransportApplicationCodeVer13Funnel implements Funnel<OFPortOpticalTransportApplicationCodeVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFPortOpticalTransportApplicationCodeVer13 message, PrimitiveSink sink) {
            sink.putInt(message.featureType);
            sink.putShort(message.oicType);
            sink.putUnencodedChars(message.appCode);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFPortOpticalTransportApplicationCodeVer13> {
        @Override
        public void write(ChannelBuffer bb, OFPortOpticalTransportApplicationCodeVer13 message) {
            bb.writeShort(U16.t(message.featureType));
            bb.writeByte(U8.t(message.oicType));
            ChannelUtils.writeFixedLengthString(bb, message.appCode, 15);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFPortOpticalTransportApplicationCodeVer13(");
        b.append("featureType=").append(featureType);
        b.append(", ");
        b.append("oicType=").append(oicType);
        b.append(", ");
        b.append("appCode=").append(appCode);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFPortOpticalTransportApplicationCodeVer13 other = (OFPortOpticalTransportApplicationCodeVer13) obj;

        if( featureType != other.featureType)
            return false;
        if( oicType != other.oicType)
            return false;
        if (appCode == null) {
            if (other.appCode != null)
                return false;
        } else if (!appCode.equals(other.appCode))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + featureType;
        result = prime * result + oicType;
        result = prime * result + ((appCode == null) ? 0 : appCode.hashCode());
        return result;
    }

}
