// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver14;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOxmBsnInPorts128MaskedVer14 implements OFOxmBsnInPorts128Masked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnInPorts128MaskedVer14.class);
    // version: 1.4
    final static byte WIRE_VERSION = 5;
    final static int LENGTH = 36;

        private final static OFBitMask128 DEFAULT_VALUE = OFBitMask128.NONE;
        private final static OFBitMask128 DEFAULT_VALUE_MASK = OFBitMask128.NONE;

    // OF message fields
    private final OFBitMask128 value;
    private final OFBitMask128 mask;
//
    // Immutable default instance
    final static OFOxmBsnInPorts128MaskedVer14 DEFAULT = new OFOxmBsnInPorts128MaskedVer14(
        DEFAULT_VALUE, DEFAULT_VALUE_MASK
    );

    // package private constructor - used by readers, builders, and factory
    OFOxmBsnInPorts128MaskedVer14(OFBitMask128 value, OFBitMask128 mask) {
        if(value == null) {
            throw new NullPointerException("OFOxmBsnInPorts128MaskedVer14: property value cannot be null");
        }
        if(mask == null) {
            throw new NullPointerException("OFOxmBsnInPorts128MaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    // Accessors for OF message fields
    @Override
    public long getTypeLen() {
        return 0x30120L;
    }

    @Override
    public OFBitMask128 getValue() {
        return value;
    }

    @Override
    public OFBitMask128 getMask() {
        return mask;
    }

    @Override
    public MatchField<OFBitMask128> getMatchField() {
        return MatchField.BSN_IN_PORTS_128;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    public OFOxm<OFBitMask128> getCanonical() {
        if (OFBitMask128.NO_MASK.equals(mask)) {
            return new OFOxmBsnInPorts128Ver14(value);
        } else if(OFBitMask128.FULL_MASK.equals(mask)) {
            return null;
        } else {
            return this;
        }
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



    public OFOxmBsnInPorts128Masked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOxmBsnInPorts128Masked.Builder {
        final OFOxmBsnInPorts128MaskedVer14 parentMessage;

        // OF message fields
        private boolean valueSet;
        private OFBitMask128 value;
        private boolean maskSet;
        private OFBitMask128 mask;

        BuilderWithParent(OFOxmBsnInPorts128MaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public long getTypeLen() {
        return 0x30120L;
    }

    @Override
    public OFBitMask128 getValue() {
        return value;
    }

    @Override
    public OFOxmBsnInPorts128Masked.Builder setValue(OFBitMask128 value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public OFBitMask128 getMask() {
        return mask;
    }

    @Override
    public OFOxmBsnInPorts128Masked.Builder setMask(OFBitMask128 mask) {
        this.mask = mask;
        this.maskSet = true;
        return this;
    }
    @Override
    public MatchField<OFBitMask128> getMatchField() {
        return MatchField.BSN_IN_PORTS_128;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFBitMask128> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



        @Override
        public OFOxmBsnInPorts128Masked build() {
                OFBitMask128 value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");
                OFBitMask128 mask = this.maskSet ? this.mask : parentMessage.mask;
                if(mask == null)
                    throw new NullPointerException("Property mask must not be null");

                //
                return new OFOxmBsnInPorts128MaskedVer14(
                    value,
                    mask
                );
        }

    }

    static class Builder implements OFOxmBsnInPorts128Masked.Builder {
        // OF message fields
        private boolean valueSet;
        private OFBitMask128 value;
        private boolean maskSet;
        private OFBitMask128 mask;

    @Override
    public long getTypeLen() {
        return 0x30120L;
    }

    @Override
    public OFBitMask128 getValue() {
        return value;
    }

    @Override
    public OFOxmBsnInPorts128Masked.Builder setValue(OFBitMask128 value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public OFBitMask128 getMask() {
        return mask;
    }

    @Override
    public OFOxmBsnInPorts128Masked.Builder setMask(OFBitMask128 mask) {
        this.mask = mask;
        this.maskSet = true;
        return this;
    }
    @Override
    public MatchField<OFBitMask128> getMatchField() {
        return MatchField.BSN_IN_PORTS_128;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFBitMask128> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

//
        @Override
        public OFOxmBsnInPorts128Masked build() {
            OFBitMask128 value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");
            OFBitMask128 mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if(mask == null)
                throw new NullPointerException("Property mask must not be null");


            return new OFOxmBsnInPorts128MaskedVer14(
                    value,
                    mask
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOxmBsnInPorts128Masked> {
        @Override
        public OFOxmBsnInPorts128Masked readFrom(ChannelBuffer bb) throws OFParseError {
            // fixed value property typeLen == 0x30120L
            int typeLen = bb.readInt();
            if(typeLen != 0x30120)
                throw new OFParseError("Wrong typeLen: Expected=0x30120L(0x30120L), got="+typeLen);
            OFBitMask128 value = OFBitMask128.read16Bytes(bb);
            OFBitMask128 mask = OFBitMask128.read16Bytes(bb);

            OFOxmBsnInPorts128MaskedVer14 oxmBsnInPorts128MaskedVer14 = new OFOxmBsnInPorts128MaskedVer14(
                    value,
                      mask
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oxmBsnInPorts128MaskedVer14);
            return oxmBsnInPorts128MaskedVer14;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOxmBsnInPorts128MaskedVer14Funnel FUNNEL = new OFOxmBsnInPorts128MaskedVer14Funnel();
    static class OFOxmBsnInPorts128MaskedVer14Funnel implements Funnel<OFOxmBsnInPorts128MaskedVer14> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOxmBsnInPorts128MaskedVer14 message, PrimitiveSink sink) {
            // fixed value property typeLen = 0x30120L
            sink.putInt(0x30120);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOxmBsnInPorts128MaskedVer14> {
        @Override
        public void write(ChannelBuffer bb, OFOxmBsnInPorts128MaskedVer14 message) {
            // fixed value property typeLen = 0x30120L
            bb.writeInt(0x30120);
            message.value.write16Bytes(bb);
            message.mask.write16Bytes(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnInPorts128MaskedVer14(");
        b.append("value=").append(value);
        b.append(", ");
        b.append("mask=").append(mask);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOxmBsnInPorts128MaskedVer14 other = (OFOxmBsnInPorts128MaskedVer14) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        if (mask == null) {
            if (other.mask != null)
                return false;
        } else if (!mask.equals(other.mask))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        result = prime * result + ((mask == null) ? 0 : mask.hashCode());
        return result;
    }

}
