/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnSetAuxCxnsReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnSetAuxCxnsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;

public class OFBsnSetAuxCxnsReplyVer13Test {
    OFFactory factory;
    static final byte[] BSN_SET_AUX_CXNS_REPLY_SERIALIZED = new byte[]{4, 4, 0, 24, 18, 52, 86, 120, 0, 92, 22, -57, 0, 0, 0, 59, 0, 0, 0, 1, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnSetAuxCxnsReply.Builder builder = this.factory.buildBsnSetAuxCxnsReply();
        builder.setXid(305419896L).setNumAux(1L).setStatus(0L);
        OFBsnSetAuxCxnsReply bsnSetAuxCxnsReply = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnSetAuxCxnsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_SET_AUX_CXNS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnSetAuxCxnsReply.Builder builder = this.factory.buildBsnSetAuxCxnsReply();
        builder.setXid(305419896L).setNumAux(1L).setStatus(0L);
        OFBsnSetAuxCxnsReply bsnSetAuxCxnsReplyBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_SET_AUX_CXNS_REPLY_SERIALIZED);
        OFBsnSetAuxCxnsReply bsnSetAuxCxnsReplyRead = OFBsnSetAuxCxnsReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_SET_AUX_CXNS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnSetAuxCxnsReplyBuilt, (Object)bsnSetAuxCxnsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_SET_AUX_CXNS_REPLY_SERIALIZED);
        OFBsnSetAuxCxnsReply bsnSetAuxCxnsReply = OFBsnSetAuxCxnsReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_SET_AUX_CXNS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnSetAuxCxnsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_SET_AUX_CXNS_REPLY_SERIALIZED));
    }
}

