/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionIdGotoTable;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionIds;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionIdGotoTableVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionIdsVer13;

public class OFInstructionIdGotoTableVer13Test {
    OFInstructionIds factory;
    static final byte[] INSTRUCTION_ID_GOTO_TABLE_SERIALIZED = new byte[]{0, 1, 0, 4};

    @Before
    public void setup() {
        this.factory = OFInstructionIdsVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFInstructionIdGotoTable instructionIdGotoTable = this.factory.gotoTable();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        instructionIdGotoTable.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_ID_GOTO_TABLE_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFInstructionIdGotoTable instructionIdGotoTableBuilt = this.factory.gotoTable();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])INSTRUCTION_ID_GOTO_TABLE_SERIALIZED);
        OFInstructionIdGotoTable instructionIdGotoTableRead = OFInstructionIdGotoTableVer13.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_ID_GOTO_TABLE_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)instructionIdGotoTableBuilt, (Object)instructionIdGotoTableRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])INSTRUCTION_ID_GOTO_TABLE_SERIALIZED);
        OFInstructionIdGotoTable instructionIdGotoTable = OFInstructionIdGotoTableVer13.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_ID_GOTO_TABLE_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        instructionIdGotoTable.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_ID_GOTO_TABLE_SERIALIZED));
    }
}

